/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.copper_guns.network;

import java.util.function.Supplier;
import net.mcreator.copper_guns.CopperGunsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CopperGunsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CopperGunsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.exp = message.data.exp;
                    variables.exp_max = message.data.exp_max;
                    variables.lvl = message.data.lvl;
                    variables.points = message.data.points;
                    variables.skillAccuracy = message.data.skillAccuracy;
                    variables.skillLuckyBullet = message.data.skillLuckyBullet;
                    variables.skillFiringRate = message.data.skillFiringRate;
                    variables.skillFastReload = message.data.skillFastReload;
                    variables.skillMotivation = message.data.skillMotivation;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double exp = 0.0;
        public double exp_max = 0.0;
        public double lvl = 1.0;
        public double points = 0.0;
        public double skillAccuracy = 0.0;
        public double skillLuckyBullet = 0.0;
        public double skillFiringRate = 0.0;
        public double skillFastReload = 0.0;
        public double skillMotivation = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CopperGunsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("exp", this.exp);
            nbt.m_128347_("exp_max", this.exp_max);
            nbt.m_128347_("lvl", this.lvl);
            nbt.m_128347_("points", this.points);
            nbt.m_128347_("skillAccuracy", this.skillAccuracy);
            nbt.m_128347_("skillLuckyBullet", this.skillLuckyBullet);
            nbt.m_128347_("skillFiringRate", this.skillFiringRate);
            nbt.m_128347_("skillFastReload", this.skillFastReload);
            nbt.m_128347_("skillMotivation", this.skillMotivation);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.exp = nbt.m_128459_("exp");
            this.exp_max = nbt.m_128459_("exp_max");
            this.lvl = nbt.m_128459_("lvl");
            this.points = nbt.m_128459_("points");
            this.skillAccuracy = nbt.m_128459_("skillAccuracy");
            this.skillLuckyBullet = nbt.m_128459_("skillLuckyBullet");
            this.skillFiringRate = nbt.m_128459_("skillFiringRate");
            this.skillFastReload = nbt.m_128459_("skillFastReload");
            this.skillMotivation = nbt.m_128459_("skillMotivation");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("copper_guns", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.exp = original.exp;
            clone.exp_max = original.exp_max;
            clone.lvl = original.lvl;
            clone.points = original.points;
            clone.skillAccuracy = original.skillAccuracy;
            clone.skillLuckyBullet = original.skillLuckyBullet;
            clone.skillFiringRate = original.skillFiringRate;
            clone.skillFastReload = original.skillFastReload;
            clone.skillMotivation = original.skillMotivation;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

