/*
 * Decompiled with CFR 0.152.
 */
package org.AlexTronStudios.betterbeaconeffects;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.AlexTronStudios.betterbeaconeffects.beaconEffectApi.BeaconEffect;
import org.AlexTronStudios.betterbeaconeffects.beaconEffectApi.BeaconEffectRegistry;
import org.AlexTronStudios.betterbeaconeffects.beaconEffectApi.BeaconRenderSettings;
import org.AlexTronStudios.betterbeaconeffects.utils.Pair;
import org.AlexTronStudios.betterbeaconeffects.utils.RenderUtils;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CustomBeaconRender
implements BlockEntityRenderer<BeaconBlockEntity> {
    public static final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/beacon_beam_no_texture.png");
    public static final ResourceLocation TEXTURE_OUT = new ResourceLocation("textures/misc/beacon_out.png");
    public static final ResourceLocation TEXTURE_IN = new ResourceLocation("textures/misc/beacon_in.png");
    public static final int MAX_RENDER_Y = 1024;
    private static final Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final float PiSin = (float)Math.sin(0.7853981633974483);

    public CustomBeaconRender(BlockEntityRendererProvider.Context p_173529_) {
    }

    public void render(BeaconBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int overlayIn) {
        long i = blockEntity.m_58904_().m_46467_();
        CustomBeaconRender.renderNetherStar(poseStack, multiBufferSource, 4.0f, i, partialTicks);
        List list = blockEntity.m_58702_();
        int j = 0;
        List<Pair<ResourceLocation, Block>> blocks = BeaconEffectRegistry.getBlockRegistry();
        ArrayList<ResourceLocation> activeEffects = new ArrayList<ResourceLocation>();
        BeaconEffect renderer = null;
        for (int x = -3; x < 4; ++x) {
            for (int y = -3; y < 4; ++y) {
                for (int z = -3; z < 4; ++z) {
                    for (Pair<ResourceLocation, Block> block : blocks) {
                        BlockPos pos = blockEntity.m_58899_().m_7918_(x, y, z);
                        if (!blockEntity.m_58904_().m_8055_(pos).m_60734_().equals(block.second)) continue;
                        activeEffects.add((ResourceLocation)block.first);
                    }
                }
            }
        }
        BeaconRenderSettings settings = new BeaconRenderSettings(blockEntity, poseStack, multiBufferSource, partialTicks, i, 0, 0, new float[]{0.0f, 0.0f, 0.0f}, new ResourceLocation(BEAM_LOCATION.m_135827_(), BEAM_LOCATION.m_135815_()), 0.125f, 5);
        for (ResourceLocation activeEffect : activeEffects) {
            BeaconEffect effect = BeaconEffectRegistry.getRegistry().get(activeEffect);
            if (effect.hasCustomRender()) {
                renderer = effect;
            }
            effect.customRenderStep(settings);
        }
        for (int k = 0; k < list.size(); ++k) {
            BeaconBlockEntity.BeaconBeamSection beaconblockentity$beaconbeamsection = (BeaconBlockEntity.BeaconBeamSection)list.get(k);
            CustomBeaconRender.renderBeaconBeam(blockEntity, poseStack, multiBufferSource, partialTicks, i, j, k == list.size() - 1 ? 1024 : beaconblockentity$beaconbeamsection.m_58723_(), beaconblockentity$beaconbeamsection.m_58722_(), activeEffects, renderer);
            j += beaconblockentity$beaconbeamsection.m_58723_();
        }
    }

    public static void renderBeaconBeam(BeaconBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, float partialTicks, long time, int baseHeight, int height, float[] color, List<ResourceLocation> activeEffects, @Nullable BeaconEffect renderer) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        float[] c = new float[]{color[0], color[1], color[2]};
        BeaconRenderSettings settings = new BeaconRenderSettings(blockEntity, poseStack, multiBufferSource, partialTicks, time, baseHeight, height, c, new ResourceLocation(BEAM_LOCATION.m_135827_(), BEAM_LOCATION.m_135815_()), 0.125f, 5);
        for (ResourceLocation activeEffect : activeEffects) {
            BeaconEffect effect = BeaconEffectRegistry.getRegistry().get(activeEffect);
            if (effect.hasCustomRender()) {
                renderer = effect;
            }
            effect.alterRenderer(settings);
        }
        if (renderer != null) {
            renderer.customRenderer(settings);
        } else {
            for (int i = 0; i < settings.beams; ++i) {
                float s = i * 4 + 4;
                float s1 = s / 2.0f;
                RenderUtils.renderTube(poseStack.m_85850_().m_252922_(), multiBufferSource.m_6299_(settings.renderType), new Vector3f(-s1, (float)(settings.baseHeight * 16), -s1), new Vector3f(s1, (float)(settings.height * 16), s1), settings.color[0], settings.color[1], settings.color[2], settings.alpha, 0.0f, (float)settings.time / 5.0f, 1.0f, (float)height + (float)settings.time / 5.0f, 0xF000F0);
            }
        }
        poseStack.m_85849_();
    }

    private static void renderNetherStar(PoseStack matrixStackIn, MultiBufferSource bufferIn, float radius, long totalWorldTime, float partialTicks) {
        CustomBeaconRender.renderNetherStar(matrixStackIn, bufferIn, 1.0f, 1.0f, 1.0f, 1.0f, radius, totalWorldTime, partialTicks);
    }

    public static float sinWave(long totalWorldTime, float partialTicks) {
        float f = (float)totalWorldTime + partialTicks;
        float f1 = Mth.m_14031_((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 2.4f;
    }

    private static void renderNetherStar(PoseStack matrixStackIn, MultiBufferSource bufferIn, float red, float green, float blue, float alpha, float radius, long totalWorldTime, float partialTicks) {
        float f = (float)Math.floorMod(totalWorldTime, 160L) + partialTicks;
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 0.125f, 0.5f);
        float f1 = ((float)totalWorldTime + partialTicks) * 3.0f;
        float f2 = CustomBeaconRender.sinWave(totalWorldTime, partialTicks);
        matrixStackIn.m_85837_(0.0, (double)(1.5f + f2 / 2.0f), 0.0);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, PiSin, 0.0f, PiSin));
        RenderUtils.renderPart(matrixStackIn.m_85850_().m_252922_(), bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE_OUT)), new Vector3f(-radius, -radius, -radius), new Vector3f(radius, radius, radius), red, green, blue, alpha);
        RenderUtils.renderPart(matrixStackIn.m_85850_().m_252922_(), bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_OUT)), new Vector3f(-radius, -radius, -radius), new Vector3f(radius, radius, radius), red, green, blue, alpha);
        matrixStackIn.m_85841_(0.875f, 0.875f, 0.875f);
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, PiSin, 0.0f, PiSin));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
        RenderUtils.renderPart(matrixStackIn.m_85850_().m_252922_(), bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE_OUT)), new Vector3f(-radius, -radius, -radius), new Vector3f(radius, radius, radius), red, green, blue, alpha);
        RenderUtils.renderPart(matrixStackIn.m_85850_().m_252922_(), bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_OUT)), new Vector3f(-radius, -radius, -radius), new Vector3f(radius, radius, radius), red, green, blue, alpha);
        matrixStackIn.m_85841_(0.875f, 0.875f, 0.875f);
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, PiSin, 0.0f, PiSin));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
        RenderUtils.renderPart(matrixStackIn.m_85850_().m_252922_(), bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE_IN)), new Vector3f(-radius, -radius, -radius), new Vector3f(radius, radius, radius), red, green, blue, alpha);
        RenderUtils.renderPart(matrixStackIn.m_85850_().m_252922_(), bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_IN)), new Vector3f(-radius, -radius, -radius), new Vector3f(radius, radius, radius), red, green, blue, alpha);
        matrixStackIn.m_85849_();
    }

    public boolean shouldRenderOffScreen(BeaconBlockEntity p_112306_) {
        return true;
    }

    public boolean shouldRender(BeaconBlockEntity p_173568_, Vec3 p_173569_) {
        return true;
    }
}

