/*
 * Decompiled with CFR 0.152.
 */
package org.AlexTronStudios.betterbeaconeffects.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class MyMath {
    public static int[] HSLtoRGB(float h, float s, float l, float alpha) {
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0f || l > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            String message = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        int r = Math.round(Math.max(0.0f, MyMath.HueToRGB(p, q, (h /= 360.0f) + 0.33333334f) * 256.0f));
        int g = Math.round(Math.max(0.0f, MyMath.HueToRGB(p, q, h) * 256.0f));
        int b = Math.round(Math.max(0.0f, MyMath.HueToRGB(p, q, h - 0.33333334f) * 256.0f));
        int[] array = new int[]{r, g, b};
        return array;
    }

    private static float HueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public static Vector3d add(Vector3d a, Vector3d b) {
        return new Vector3d(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3d mul(Vector3d a, double b) {
        return new Vector3d(a.x * b, a.y * b, a.z * b);
    }

    public static Vec3 mul(Vec3 a, double b) {
        return new Vec3(a.f_82479_ * b, a.f_82480_ * b, a.f_82481_ * b);
    }

    public static Vector3d toD(Vec3i in) {
        return new Vector3d((double)in.m_123341_(), (double)in.m_123342_(), (double)in.m_123343_());
    }

    public static double lerp(double f, double a, double b) {
        return a + f * (b - a);
    }

    public static float lerp(float f, float a, float b) {
        return a + f * (b - a);
    }

    public static Vector3d atCenterOf(BlockPos pos) {
        return new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static Vector3d normalize(Vector3d v) {
        double sum = v.x + v.y + v.z;
        return new Vector3d(v.x / sum, v.y / sum, v.z / sum);
    }
}

