/*
 * Decompiled with CFR 0.152.
 */
package org.AlexTronStudios.betterbeaconeffects.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.AlexTronStudios.betterbeaconeffects.utils.Pair;
import org.AlexTronStudios.betterbeaconeffects.utils.Triplet;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderUtils {
    private static final List<Triplet<Float, Float, Float>> vectorPairs = new ArrayList<Triplet<Float, Float, Float>>();
    private static final List<Pair<Integer, Integer>> lines = new ArrayList<Pair<Integer, Integer>>();
    private static boolean listLoaded = false;
    public static final float SIN_45 = (float)Math.sin(0.7853981633974483);

    private static void addToList() {
        if (!listLoaded) {
            vectorPairs.add(new Triplet<Float, Float, Float>(Float.valueOf(-0.0625f), Float.valueOf(-0.0625f), Float.valueOf(-0.0625f)));
            vectorPairs.add(new Triplet<Float, Float, Float>(Float.valueOf(-0.0625f), Float.valueOf(-0.0625f), Float.valueOf(0.0625f)));
            vectorPairs.add(new Triplet<Float, Float, Float>(Float.valueOf(0.0625f), Float.valueOf(0.0625f), Float.valueOf(0.0625f)));
            vectorPairs.add(new Triplet<Float, Float, Float>(Float.valueOf(0.0625f), Float.valueOf(0.0625f), Float.valueOf(-0.0625f)));
            lines.add(new Pair<Integer, Integer>(0, 1));
            lines.add(new Pair<Integer, Integer>(1, 2));
            lines.add(new Pair<Integer, Integer>(2, 3));
            lines.add(new Pair<Integer, Integer>(3, 0));
            listLoaded = true;
        }
    }

    public static void renderPart(Matrix4f stackIn, VertexConsumer bufferIn, Vector3f start, Vector3f end, float r, float g, float b, float a) {
        RenderUtils.renderPart(stackIn, bufferIn, start, end, r, g, b, a, 0, 0, 1, 1);
    }

    public static void renderTube(Matrix4f stackIn, VertexConsumer bufferIn, Vector3f start, Vector3f end, float r, float g, float b, float a) {
        RenderUtils.renderTube(stackIn, bufferIn, start, end, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0);
    }

    public static void renderPart(Matrix4f stackIn, VertexConsumer bufferIn, Vector3f start, Vector3f end, float r, float g, float b, float a, int u1, int v1, int u2, int v2) {
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(end.x()), RenderUtils.convert(start.y()), RenderUtils.convert(end.y()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), r, g, b, a, u1, v1, u2, v2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(end.x()), RenderUtils.convert(end.y()), RenderUtils.convert(start.y()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(end.x()), RenderUtils.convert(end.x()), RenderUtils.convert(end.y()), RenderUtils.convert(start.y()), RenderUtils.convert(start.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(start.x()), RenderUtils.convert(start.y()), RenderUtils.convert(end.y()), RenderUtils.convert(start.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(end.x()), RenderUtils.convert(start.y()), RenderUtils.convert(start.y()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), r, g, b, a, u1, v1, u2, v2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(end.x()), RenderUtils.convert(end.y()), RenderUtils.convert(end.y()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2);
    }

    public static void renderTube(Matrix4f stackIn, VertexConsumer bufferIn, Vector3f start, Vector3f end, float r, float g, float b, float a, float u1, float v1, float u2, float v2, int uv2) {
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(end.x()), RenderUtils.convert(start.y()), RenderUtils.convert(end.y()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), r, g, b, a, u1, v1, u2, v2, uv2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(end.x()), RenderUtils.convert(end.y()), RenderUtils.convert(start.y()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2, uv2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(end.x()), RenderUtils.convert(end.x()), RenderUtils.convert(end.y()), RenderUtils.convert(start.y()), RenderUtils.convert(start.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2, uv2);
        RenderUtils.renderFace(stackIn, bufferIn, RenderUtils.convert(start.x()), RenderUtils.convert(start.x()), RenderUtils.convert(start.y()), RenderUtils.convert(end.y()), RenderUtils.convert(start.z()), RenderUtils.convert(end.z()), RenderUtils.convert(end.z()), RenderUtils.convert(start.z()), r, g, b, a, u1, v1, u2, v2, uv2);
    }

    public static void renderLine3d(Matrix4f stackIn, VertexConsumer bufferIn, Vector3f start, Vector3f end, float size, float r, float g, float b, float a) {
        RenderUtils.renderLine3d(stackIn, bufferIn, start, end, size, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f, 0, 1);
    }

    public static void renderLine3d(Matrix4f stackIn, VertexConsumer bufferIn, Vector3f start, Vector3f end, float size, float r, float g, float b, float a, float u, float v, float u1, float v1, int u2, int v2) {
        RenderUtils.addToList();
        for (Pair<Integer, Integer> line : lines) {
            Vector3f st = new Vector3f(start.x() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.first).intValue()).first).floatValue() * size, start.y() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.first).intValue()).second).floatValue() * size, start.z() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.first).intValue()).third).floatValue() * size);
            Vector3f nd = new Vector3f(end.x() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.first).intValue()).first).floatValue() * size, end.y() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.first).intValue()).second).floatValue() * size, end.z() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.first).intValue()).third).floatValue() * size);
            Vector3f th = new Vector3f(start.x() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.second).intValue()).first).floatValue() * size, start.y() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.second).intValue()).second).floatValue() * size, start.z() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.second).intValue()).third).floatValue() * size);
            Vector3f rd = new Vector3f(end.x() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.second).intValue()).first).floatValue() * size, end.y() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.second).intValue()).second).floatValue() * size, end.z() + ((Float)RenderUtils.vectorPairs.get((int)((Integer)line.second).intValue()).third).floatValue() * size);
            RenderUtils.renderFace(stackIn, bufferIn, st, nd, rd, th, r, g, b, a, u, v, u1, v1, u2, v2);
        }
    }

    public static void renderLine(PoseStack poseStack, MultiBufferSource multiBufferSource, Vector3f start, Vector3f end, float r, float g, float b, float a) {
        VertexConsumer bufferIn = multiBufferSource.m_6299_((RenderType)RenderType.f_110371_);
        Matrix4f stackIn = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        bufferIn.m_252986_(stackIn, start.x(), start.y(), start.z()).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        bufferIn.m_252986_(stackIn, end.x(), end.y(), end.z()).m_85950_(r, g, b, a).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }

    public static float convert(float in) {
        return in / 16.0f;
    }

    public static float getY(long time, float partialTicks) {
        float f = (float)time + partialTicks;
        float f1 = (float)Math.sin(f * 0.2f) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    public static void renderFace(Matrix4f matrix4f, VertexConsumer iVertexBuilder, float startX, float endX, float startY, float endY, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float r, float g, float b, float a, int u1, int v1, int u2, int v2) {
        iVertexBuilder.m_252986_(matrix4f, startX, startY, p_228884_8_).m_85950_(r, g, b, a).m_7421_((float)u1, (float)v1).m_86008_(OverlayTexture.f_118083_).m_7120_(1, 1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, endX, startY, p_228884_9_).m_85950_(r, g, b, a).m_7421_((float)u2, (float)v1).m_86008_(OverlayTexture.f_118083_).m_7120_(1, 1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, endX, endY, p_228884_10_).m_85950_(r, g, b, a).m_7421_((float)u2, (float)v2).m_86008_(OverlayTexture.f_118083_).m_7120_(1, 1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, startX, endY, p_228884_11_).m_85950_(r, g, b, a).m_7421_((float)u1, (float)v2).m_86008_(OverlayTexture.f_118083_).m_7120_(1, 1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderFace(Matrix4f matrix4f, VertexConsumer iVertexBuilder, float startX, float endX, float startY, float endY, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float r, float g, float b, float a, float u1, float v1, float u2, float v2, int uv2) {
        iVertexBuilder.m_252986_(matrix4f, startX, startY, p_228884_8_).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(uv2).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, endX, startY, p_228884_9_).m_85950_(r, g, b, a).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(uv2).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, endX, endY, p_228884_10_).m_85950_(r, g, b, a).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(uv2).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, startX, endY, p_228884_11_).m_85950_(r, g, b, a).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(uv2).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderFace(Matrix4f matrix4f, VertexConsumer vertexConsumer, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, float r, float g, float b, float a, float u, float v, float u0, float v0, int i, int i1) {
        vertexConsumer.m_252986_(matrix4f, v1.x(), v1.y(), v1.z()).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_7120_(i, i1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, v2.x(), v2.y(), v2.z()).m_85950_(r, g, b, a).m_7421_(u0, v).m_86008_(OverlayTexture.f_118083_).m_7120_(i, i1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, v3.x(), v3.y(), v3.z()).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_7120_(i, i1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, v4.x(), v4.y(), v4.z()).m_85950_(r, g, b, a).m_7421_(u, v0).m_86008_(OverlayTexture.f_118083_).m_7120_(i, i1).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static float xOffset(float f) {
        return f * 0.1f;
    }

    public static float yOffset(float f) {
        return f * 0.01f;
    }

    public static class RenderSystemManager {
        private static final Tesselator TESSELLATOR = RenderSystem.renderThreadTesselator();
        private static final BufferBuilder BUFFER_BUILDER = TESSELLATOR.m_85915_();

        public static void defaultTransparency() {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }

        public static void additiveTransparency() {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }

        public static void electricTransparency() {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }

        public static void bindTexture(ResourceLocation texture) {
            RenderSystemManager.bindTexture(texture, false, false);
        }

        public static void bindTexture(ResourceLocation texture, boolean blur, boolean mipmap) {
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            texturemanager.m_174784_(texture);
            texturemanager.m_118506_(texture).setBlurMipmap(blur, mipmap);
        }

        public static void noTexture() {
            ResourceLocation texture = new ResourceLocation("textures/entity/beacon_beam_no_texture.png");
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            texturemanager.m_174784_(texture);
            texturemanager.m_118506_(texture).setBlurMipmap(false, false);
        }

        public static final Tesselator getTessellator() {
            return TESSELLATOR;
        }

        public static BufferBuilder getBuilder() {
            return BUFFER_BUILDER;
        }

        public static void begin() {
            RenderSystemManager.begin(BUFFER_BUILDER);
        }

        protected static void begin(BufferBuilder bufferBuilder) {
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        }

        public static void end() {
            RenderSystemManager.end(BUFFER_BUILDER);
        }

        protected static void end(BufferBuilder bufferBuilder) {
            bufferBuilder.m_231175_();
        }
    }
}

