/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.BookModelLoader;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.datagen.DataGenerators;
import com.klikli_dev.modonomicon.integration.LecternIntegration;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.registry.CommandRegistry;
import com.klikli_dev.modonomicon.registry.CreativeModeTabRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="modonomicon")
public class ModonomiconNeo {
    public ModonomiconNeo(IEventBus modEventBus, ModContainer modContainer) {
        Modonomicon.init();
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.get().spec);
        CreativeModeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(Networking::register);
        modEventBus.addListener(CreativeModeTabRegistry::onCreativeModeTabBuildContents);
        NeoForge.EVENT_BUS.addListener(e -> {
            BookDataManager.get().registries((HolderLookup.Provider)e.getRegistryAccess());
            e.addListener((PreparableReloadListener)BookDataManager.get());
            MultiblockDataManager.get().registries((HolderLookup.Provider)e.getRegistryAccess());
            e.addListener((PreparableReloadListener)MultiblockDataManager.get());
        });
        NeoForge.EVENT_BUS.addListener(e -> CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> CommandRegistry.registerClientCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() != null) {
                BookDataManager.get().onDatapackSync(e.getPlayer());
                MultiblockDataManager.get().onDatapackSync(e.getPlayer());
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            Entity patt0$temp = e.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                BookUnlockStateManager.get().updateAndSyncFor(player);
                BookVisualStateManager.get().syncFor(player);
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            Level level;
            LevelAccessor patt0$temp = e.getLevel();
            if (patt0$temp instanceof Level && (level = (Level)patt0$temp).dimension() == Level.OVERWORLD) {
                BookUnlockStateManager.get().saveData = null;
                BookVisualStateManager.get().saveData = null;
            }
        });
        NeoForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onAdvancement((ServerPlayer)e.getEntity()));
        NeoForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onServerTickEnd(e.getServer()));
        modEventBus.addListener(DataGenerators::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(Client::onClientSetup);
            modEventBus.addListener(Client::onRegisterGeometryLoaders);
            modEventBus.addListener(Client::onRegisterGuiOverlays);
            NeoForge.EVENT_BUS.addListener(Client::onRecipesUpdated);
            modEventBus.addListener(e -> e.registerReloadListener((PreparableReloadListener)BookDataManager.Client.get()));
            Client.registerConfigScreen(modContainer);
        }
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        LoaderRegistry.registerLoaders();
        NeoForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternIntegration.rightClick(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.consumesAction()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
    }

    public static class Client {
        public static void onClientSetup(FMLClientSetupEvent event) {
            PageRendererRegistry.registerPageRenderers();
            NeoForge.EVENT_BUS.addListener(e -> {
                ClientTicks.endClientTick(Minecraft.getInstance());
                MultiblockPreviewRenderer.onClientTick(Minecraft.getInstance());
            });
            NeoForge.EVENT_BUS.addListener(e -> ClientTicks.renderTickStart(e.getPartialTick().getGameTimeDeltaPartialTick(true)));
            NeoForge.EVENT_BUS.addListener(e -> ClientTicks.renderTickEnd());
            NeoForge.EVENT_BUS.addListener(e -> {
                InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result.consumesAction()) {
                    e.setCanceled(true);
                    e.setCancellationResult(result);
                }
            });
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                    MultiblockPreviewRenderer.onRenderLevelLastEvent(e.getPoseStack());
                }
            });
        }

        public static void registerConfigScreen(ModContainer modContainer) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }

        public static void onRecipesUpdated(RecipesUpdatedEvent event) {
            BookDataManager.get().onRecipesUpdated((Level)Minecraft.getInstance().level);
        }

        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register(Modonomicon.loc("book_model_loader"), (IGeometryLoader)new BookModelLoader());
        }

        public static void onRegisterGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerBelow(VanillaGuiLayers.BOSS_OVERLAY, Modonomicon.loc("multiblock_hud"), (guiGraphics, partialTicks) -> MultiblockPreviewRenderer.onRenderHUD(guiGraphics, partialTicks.getGameTimeDeltaPartialTick(true)));
        }
    }
}

