/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.conditions;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionContext;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.RequestAdvancementMessage;
import com.klikli_dev.modonomicon.platform.Services;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;

public class BookAdvancementCondition
extends BookCondition {
    protected ResourceLocation advancementId;

    public BookAdvancementCondition(Component component, ResourceLocation advancementId) {
        super(component);
        this.advancementId = advancementId;
    }

    public static BookAdvancementCondition fromJson(ResourceLocation conditionParentId, JsonObject json, HolderLookup.Provider provider) {
        ResourceLocation advancementId = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)json, (String)"advancement_id"));
        MutableComponent tooltip = null;
        if (json.has("tooltip")) {
            tooltip = BookAdvancementCondition.tooltipFromJson(json, provider);
        }
        return new BookAdvancementCondition((Component)tooltip, advancementId);
    }

    public static BookAdvancementCondition fromNetwork(RegistryFriendlyByteBuf buffer) {
        Component tooltip = buffer.readBoolean() ? (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer) : null;
        ResourceLocation advancementId = buffer.readResourceLocation();
        return new BookAdvancementCondition(tooltip, advancementId);
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Condition.ADVANCEMENT;
    }

    @Override
    public void toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)this.tooltip);
        }
        buffer.writeResourceLocation(this.advancementId);
    }

    @Override
    public boolean test(BookConditionContext context, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHolder advancement = serverPlayer.getServer().getAdvancements().get(this.advancementId);
            return advancement != null && serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone();
        }
        return false;
    }

    @Override
    public List<Component> getTooltip(Player player, BookConditionContext context) {
        if (this.tooltip != null) {
            return List.of(this.tooltip);
        }
        MutableComponent tooltip = Component.translatable((String)"tooltip.modonomicon.condition.advancement", (Object[])new Object[]{DistHelper.getAdvancementTitle(player, this.advancementId)});
        return List.of(tooltip);
    }

    public static class DistHelper {
        public static long lastRequestTime = 0L;

        public static Component getAdvancementTitle(Player player, ResourceLocation advancementId) {
            if (player instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)player;
                AdvancementHolder adv = localPlayer.connection.getAdvancements().get(advancementId);
                if (adv == null) {
                    adv = BookDataManager.Client.get().getAdvancement(advancementId);
                }
                if (adv == null) {
                    if (System.currentTimeMillis() - lastRequestTime > 1000L) {
                        lastRequestTime = System.currentTimeMillis();
                        Services.NETWORK.sendToServer(new RequestAdvancementMessage(advancementId));
                    }
                    return Component.translatable((String)"tooltip.modonomicon.condition.advancement.loading");
                }
                if (!adv.value().display().isPresent()) {
                    return Component.translatable((String)"tooltip.modonomicon.condition.advancement.hidden");
                }
                return ((DisplayInfo)adv.value().display().get()).getTitle();
            }
            return Component.literal((String)"Unknown");
        }
    }
}

