/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.entity.familiar.BlacksmithFamiliarEntity;
import com.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BlacksmithFamiliarModel
extends EntityModel<BlacksmithFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart wagon;
    public ModelPart rightArm;
    public ModelPart leftArm;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart head;
    public ModelPart hammer1;
    public ModelPart hammer2;
    public ModelPart nose;
    public ModelPart mouth1;
    public ModelPart leftEar;
    public ModelPart hair1;
    public ModelPart rightEar;
    public ModelPart hair2;
    public ModelPart mouth2;
    public ModelPart christmasBeard;
    public ModelPart earring;
    public ModelPart anvil1;
    public ModelPart anvil2;
    public ModelPart anvil3;
    public ModelPart wheel1;
    public ModelPart wheel2;
    public ModelPart wheel3;
    public ModelPart wheel4;
    public ModelPart anvil4;
    public ModelPart anvil5;
    public ModelPart anvil6;
    public ModelPart anvil7;

    public BlacksmithFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.wagon = part.getChild("wagon");
        this.rightArm = this.body.getChild("rightArm");
        this.leftArm = this.body.getChild("leftArm");
        this.rightLeg = this.body.getChild("rightLeg");
        this.leftLeg = this.body.getChild("leftLeg");
        this.head = this.body.getChild("head");
        this.hammer1 = this.rightArm.getChild("hammer1");
        this.hammer2 = this.hammer1.getChild("hammer2");
        this.nose = this.head.getChild("nose");
        this.mouth1 = this.head.getChild("mouth1");
        this.leftEar = this.head.getChild("leftEar");
        this.hair1 = this.head.getChild("hair1");
        this.rightEar = this.head.getChild("rightEar");
        this.hair2 = this.head.getChild("hair2");
        this.mouth2 = this.head.getChild("mouth2");
        this.christmasBeard = this.head.getChild("christmasBeard");
        this.earring = this.leftEar.getChild("earring");
        this.anvil1 = this.wagon.getChild("anvil1");
        this.anvil2 = this.wagon.getChild("anvil2");
        this.anvil3 = this.wagon.getChild("anvil3");
        this.wheel1 = this.wagon.getChild("wheel1");
        this.wheel2 = this.wagon.getChild("wheel2");
        this.wheel3 = this.wagon.getChild("wheel3");
        this.wheel4 = this.wagon.getChild("wheel4");
        this.anvil4 = this.anvil3.getChild("anvil4");
        this.anvil5 = this.anvil4.getChild("anvil5");
        this.anvil6 = this.anvil4.getChild("anvil6");
        this.anvil7 = this.anvil4.getChild("anvil7");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -1.5f, 5.0f, 5.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wagon = parts.addOrReplaceChild("wagon", CubeListBuilder.create().texOffs(14, 12).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 1.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)22.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(24, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(43, 2).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hammer1 = rightArm.addOrReplaceChild("hammer1", CubeListBuilder.create().texOffs(16, 0).addBox(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 3.0f, true), PartPose.offsetAndRotation((float)-1.0f, (float)5.0f, (float)0.0f, (float)0.625526f, (float)1.7983873f, (float)0.0f));
        PartDefinition hammer2 = hammer1.addOrReplaceChild("hammer2", CubeListBuilder.create().texOffs(14, 6).addBox(-1.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(30, 7).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.2f, (float)-1.5f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition mouth1 = head.addOrReplaceChild("mouth1", CubeListBuilder.create().texOffs(8, 26).addBox(-3.5f, -2.0f, 0.0f, 7.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.1f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(0, 26).addBox(0.0f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, false), PartPose.offsetAndRotation((float)2.4f, (float)-3.0f, (float)0.0f, (float)0.2268928f, (float)-0.87266463f, (float)-0.5235988f));
        PartDefinition hair1 = head.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, true), PartPose.offsetAndRotation((float)-2.4f, (float)-3.0f, (float)0.0f, (float)0.2268928f, (float)0.87266463f, (float)0.5235988f));
        PartDefinition hair2 = head.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(42, 21).addBox(-2.0f, -5.0f, -2.0f, 4.0f, 5.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth2 = head.addOrReplaceChild("mouth2", CubeListBuilder.create().texOffs(22, 26).addBox(-3.5f, -2.0f, 0.0f, 7.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.1f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition christmasBeard = head.addOrReplaceChild("christmasBeard", CubeListBuilder.create().texOffs(0, 32).addBox(-3.5f, -2.0f, 0.0f, 7.0f, 7.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.7f, (float)((float)(-Math.PI) / 90), (float)0.0f, (float)0.0f));
        PartDefinition earring = leftEar.addOrReplaceChild("earring", CubeListBuilder.create().texOffs(0, 29).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.4f, (float)1.0f, (float)0.0f, (float)0.0f, (float)2.391799f, (float)0.0f));
        PartDefinition anvil1 = wagon.addOrReplaceChild("anvil1", CubeListBuilder.create().texOffs(42, 12).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil2 = wagon.addOrReplaceChild("anvil2", CubeListBuilder.create().texOffs(42, 12).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil3 = wagon.addOrReplaceChild("anvil3", CubeListBuilder.create().texOffs(51, 15).addBox(-1.0f, -2.0f, -1.5f, 2.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel1 = wagon.addOrReplaceChild("wheel1", CubeListBuilder.create().texOffs(34, 14).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)3.5f, (float)0.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel2 = wagon.addOrReplaceChild("wheel2", CubeListBuilder.create().texOffs(34, 14).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)3.5f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel3 = wagon.addOrReplaceChild("wheel3", CubeListBuilder.create().texOffs(34, 14).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-3.5f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel4 = wagon.addOrReplaceChild("wheel4", CubeListBuilder.create().texOffs(34, 14).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-3.5f, (float)0.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil4 = anvil3.addOrReplaceChild("anvil4", CubeListBuilder.create().texOffs(0, 19).addBox(-3.0f, -1.5f, -2.0f, 6.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil5 = anvil4.addOrReplaceChild("anvil5", CubeListBuilder.create().texOffs(36, 18).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)-4.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil6 = anvil4.addOrReplaceChild("anvil6", CubeListBuilder.create().texOffs(16, 19).addBox(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-0.51f, (float)0.5f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        PartDefinition anvil7 = anvil4.addOrReplaceChild("anvil7", CubeListBuilder.create().texOffs(16, 19).addBox(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)-0.27366763f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        ImmutableList.of((Object)this.body, (Object)this.wagon).forEach(modelRenderer -> modelRenderer.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor));
    }

    public void setupAnim(BlacksmithFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.wheel1.xRot = limbSwing;
        this.wheel2.xRot = limbSwing;
        this.wheel3.xRot = limbSwing;
        this.wheel4.xRot = limbSwing;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.6f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.6f;
        this.leftArm.xRot = this.toRad(-30.0f) + Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f;
        this.leftArm.yRot = this.toRad(-15.0f);
        this.rightArm.xRot = this.toRad(-75.0f);
        this.rightArm.yRot = this.toRad(25.0f);
        this.hammer1.yRot = 0.0f;
        this.hammer1.zRot = this.toRad(90.0f);
        this.hammer1.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.y = 19.0f;
        this.body.xRot = 0.0f;
        this.body.z = 3.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        if (entityIn.isPartying()) {
            this.head.xRot = Mth.cos((float)(ageInTicks * 0.8f)) * this.toRad(25.0f);
            this.head.yRot = 0.0f;
            this.leftArm.xRot = this.toRad(-90.0f) + Mth.cos((float)(ageInTicks * 1.2f)) * this.toRad(25.0f);
            this.leftArm.yRot = this.toRad(-5.0f);
            this.leftArm.zRot = this.toRad(20.0f);
            this.rightArm.xRot = this.toRad(-90.0f) + Mth.cos((float)(ageInTicks * 1.2f + (float)Math.PI)) * this.toRad(25.0f);
            this.rightArm.yRot = this.toRad(-5.0f);
            this.rightArm.zRot = this.toRad(-20.0f);
        } else if (entityIn.isSitting()) {
            this.body.yRot = this.toRad(180.0f);
            this.leftLeg.xRot = this.toRad(-70.0f);
            this.rightLeg.xRot = this.toRad(-70.0f);
            this.body.y = 23.0f;
            this.body.z = 4.0f;
            this.body.xRot = this.toRad(-20.0f);
            this.head.xRot = this.toRad(20.0f);
            this.head.yRot = 0.0f;
            this.leftArm.xRot = this.toRad(-10.0f);
            this.rightArm.xRot = this.toRad(-10.0f);
        }
    }

    public void prepareMobModel(BlacksmithFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.showModels(entityIn);
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    private void showModels(BlacksmithFamiliarEntity entityIn) {
        boolean hasSquarehair = entityIn.hasSquareHair();
        boolean hasMarioMoustache = entityIn.hasMarioMoustache();
        boolean isChristmas = FamiliarUtil.isChristmas();
        this.earring.visible = entityIn.hasEarring();
        this.mouth1.visible = !hasMarioMoustache && !isChristmas;
        this.mouth2.visible = hasMarioMoustache && !isChristmas;
        this.hair1.visible = hasSquarehair;
        this.hair2.visible = !hasSquarehair;
        this.christmasBeard.visible = isChristmas;
    }
}

