/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.DragonFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Vector3f;
import software.bernie.geckolib.util.Color;

public class DragonFamiliarModel
extends EntityModel<DragonFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart neck1;
    public ModelPart leftLeg1;
    public ModelPart tail1;
    public ModelPart leftWing1;
    public ModelPart rightWing1;
    public ModelPart rightLeg1;
    public ModelPart leftArm1;
    public ModelPart rightArm1;
    public ModelPart neck2;
    public ModelPart head;
    public ModelPart jaw;
    public ModelPart fez1;
    public ModelPart leftHorn1;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart rightHorn1;
    public ModelPart tooth1;
    public ModelPart tooth2;
    public ModelPart tooth4;
    public ModelPart leftNose;
    public ModelPart rightNose;
    public ModelPart fez2;
    public ModelPart leftHorn2;
    public ModelPart rightHorn2;
    public ModelPart leftLeg2;
    public ModelPart leftLeg3;
    public ModelPart tail2;
    public ModelPart spike1;
    public ModelPart tail3;
    public ModelPart spike2;
    public ModelPart spike3;
    public ModelPart leftWing2;
    public ModelPart rightWing2;
    public ModelPart rightLeg2;
    public ModelPart rightLeg3;
    public ModelPart leftArm2;
    public ModelPart leftArm3;
    public ModelPart rightArm2;
    public ModelPart rightArm3;
    public ColorModelPartProxy leftEye;
    public ColorModelPartProxy rightEye;

    public DragonFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.neck1 = this.body.getChild("neck1");
        this.leftLeg1 = this.body.getChild("leftLeg1");
        this.tail1 = this.body.getChild("tail1");
        this.leftWing1 = this.body.getChild("leftWing1");
        this.rightWing1 = this.body.getChild("rightWing1");
        this.rightLeg1 = this.body.getChild("rightLeg1");
        this.leftArm1 = this.body.getChild("leftArm1");
        this.rightArm1 = this.body.getChild("rightArm1");
        this.neck2 = this.neck1.getChild("neck2");
        this.head = this.neck2.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.leftEye = new ColorModelPartProxy(this.head.getChild("leftEye"));
        this.rightEye = new ColorModelPartProxy(this.head.getChild("rightEye"));
        this.fez1 = this.head.getChild("fez1");
        this.leftHorn1 = this.head.getChild("leftHorn1");
        this.leftEar = this.head.getChild("leftEar");
        this.rightEar = this.head.getChild("rightEar");
        this.rightHorn1 = this.head.getChild("rightHorn1");
        this.tooth1 = this.jaw.getChild("tooth1");
        this.tooth2 = this.jaw.getChild("tooth2");
        this.tooth4 = this.jaw.getChild("tooth4");
        this.leftNose = this.jaw.getChild("leftNose");
        this.rightNose = this.jaw.getChild("rightNose");
        this.fez2 = this.fez1.getChild("fez2");
        this.leftHorn2 = this.leftHorn1.getChild("leftHorn2");
        this.rightHorn2 = this.rightHorn1.getChild("rightHorn2");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.leftLeg3 = this.leftLeg2.getChild("leftLeg3");
        this.tail2 = this.tail1.getChild("tail2");
        this.spike1 = this.tail1.getChild("spike1");
        this.tail3 = this.tail2.getChild("tail3");
        this.spike2 = this.tail2.getChild("spike2");
        this.spike3 = this.tail3.getChild("spike3");
        this.leftWing2 = this.leftWing1.getChild("leftWing2");
        this.rightWing2 = this.rightWing1.getChild("rightWing2");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.rightLeg3 = this.rightLeg2.getChild("rightLeg3");
        this.leftArm2 = this.leftArm1.getChild("leftArm2");
        this.leftArm3 = this.leftArm1.getChild("leftArm3");
        this.rightArm2 = this.rightArm1.getChild("rightArm2");
        this.rightArm3 = this.rightArm1.getChild("rightArm3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -5.0f, 4.0f, 4.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)0.0f, (float)-0.06981317f, (float)0.0f, (float)0.0f));
        PartDefinition neck1 = body.addOrReplaceChild("neck1", CubeListBuilder.create().texOffs(18, 0).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)-4.1f, (float)-0.54733527f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg1 = body.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(44, 5).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.8f, (float)0.5f, (float)2.0f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = body.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(36, 10).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)4.3f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing1 = body.addOrReplaceChild("leftWing1", CubeListBuilder.create().texOffs(0, 9).addBox(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)1.1414454f));
        PartDefinition rightWing1 = body.addOrReplaceChild("rightWing1", CubeListBuilder.create().texOffs(0, 9).addBox(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.86009824f));
        PartDefinition rightLeg1 = body.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(44, 5).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.8f, (float)0.5f, (float)2.0f, (float)0.43004912f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.addOrReplaceChild("leftArm1", CubeListBuilder.create().texOffs(0, 5).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.6f, (float)1.1f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm1 = body.addOrReplaceChild("rightArm1", CubeListBuilder.create().texOffs(0, 5).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.6f, (float)1.1f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck2 = neck1.addOrReplaceChild("neck2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.4f, (float)-0.1563815f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.4f, (float)-2.4f, (float)0.82135195f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(46, 0).addBox(-1.5f, -1.0f, -3.0f, 3.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.2f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(56, 3).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)-0.1f, (float)-2.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(56, 3).addBox(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.5f, (float)-0.1f, (float)-2.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition fez1 = head.addOrReplaceChild("fez1", CubeListBuilder.create().texOffs(18, 14).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn1 = head.addOrReplaceChild("leftHorn1", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.7f, (float)-0.5f, (float)-0.5f, (float)0.2268928f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(12, 14).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.7f, (float)-0.6f, (float)-0.6f, (float)-0.13613568f, (float)1.1798426f, (float)-0.5899213f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(12, 14).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.7f, (float)-0.6f, (float)-0.6f, (float)-0.13613568f, (float)-1.1798426f, (float)0.5899213f));
        PartDefinition rightHorn1 = head.addOrReplaceChild("rightHorn1", CubeListBuilder.create().texOffs(0, 14).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.7f, (float)-0.5f, (float)-0.5f, (float)0.2268928f, (float)0.0f, (float)0.0f));
        PartDefinition tooth1 = jaw.addOrReplaceChild("tooth1", CubeListBuilder.create().texOffs(59, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.7f, (float)-0.4f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth2 = jaw.addOrReplaceChild("tooth2", CubeListBuilder.create().texOffs(59, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.3f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth4 = jaw.addOrReplaceChild("tooth4", CubeListBuilder.create().texOffs(59, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.7f, (float)-0.4f, (float)-1.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftNose = jaw.addOrReplaceChild("leftNose", CubeListBuilder.create().texOffs(45, 1).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.8f, (float)-1.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightNose = jaw.addOrReplaceChild("rightNose", CubeListBuilder.create().texOffs(45, 1).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.8f, (float)-1.4f, (float)-2.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition fez2 = fez1.addOrReplaceChild("fez2", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -0.5f, 0.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftHorn2 = leftHorn1.addOrReplaceChild("leftHorn2", CubeListBuilder.create().texOffs(6, 14).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)0.0f, (float)1.4f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition rightHorn2 = rightHorn1.addOrReplaceChild("rightHorn2", CubeListBuilder.create().texOffs(6, 14).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)0.0f, (float)1.4f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(50, 5).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)2.4f, (float)0.5f, (float)-0.74281216f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg3 = leftLeg2.addOrReplaceChild("leftLeg3", CubeListBuilder.create().texOffs(28, 7).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.2f, (float)0.8f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(50, 10).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.3f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition spike1 = tail1.addOrReplaceChild("spike1", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(18, 6).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.4f, (float)0.19547687f, (float)0.0f, (float)0.0f));
        PartDefinition spike2 = tail2.addOrReplaceChild("spike2", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.01f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spike3 = tail3.addOrReplaceChild("spike3", CubeListBuilder.create().texOffs(8, 26).addBox(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing2 = leftWing1.addOrReplaceChild("leftWing2", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.86009824f));
        PartDefinition rightWing2 = rightWing1.addOrReplaceChild("rightWing2", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, -5.0f, -5.0f, 0.0f, 5.0f, 10.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.86009824f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(50, 5).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.01f, (float)2.4f, (float)0.5f, (float)-0.74281216f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg3 = rightLeg2.addOrReplaceChild("rightLeg3", CubeListBuilder.create().texOffs(28, 7).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)2.2f, (float)0.8f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm2 = leftArm1.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(0, 8).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition leftArm3 = leftArm1.addOrReplaceChild("leftArm3", CubeListBuilder.create().texOffs(0, 8).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        PartDefinition rightArm2 = rightArm1.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(0, 8).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition rightArm3 = rightArm1.addOrReplaceChild("rightArm3", CubeListBuilder.create().texOffs(0, 8).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.1f, (float)2.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(DragonFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.isPartying()) {
            this.head.xRot = this.toRads(50.0f) + Mth.sin((float)ageInTicks) * this.toRads(20.0f);
            this.head.yRot = Mth.sin((float)ageInTicks) * this.toRads(5.0f);
            this.head.zRot = Mth.sin((float)ageInTicks) * this.toRads(5.0f);
        } else {
            this.head.xRot = this.toRads(50.0f) + 0.03f + headPitch * ((float)Math.PI / 180) * 0.7f;
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.head.zRot = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
        }
    }

    public void prepareMobModel(DragonFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.setEyeColor(entityIn.getEyeColorR(partialTick), entityIn.getEyeColorG(partialTick), entityIn.getEyeColorB(partialTick));
        this.showModels(entityIn);
        float ageInTicks = (float)entityIn.tickCount + partialTick;
        this.tail1.zRot = 0.0f;
        this.tail2.zRot = 0.0f;
        this.tail3.zRot = 0.0f;
        this.jaw.zRot = 0.0f;
        if (entityIn.isPartying()) {
            this.tail1.zRot = Mth.sin((float)ageInTicks) * this.toRads(30.0f);
            this.tail2.zRot = -Mth.sin((float)ageInTicks) * this.toRads(60.0f);
            this.tail3.zRot = Mth.sin((float)ageInTicks) * this.toRads(90.0f);
            this.leftWing1.yRot = Mth.sin((float)ageInTicks) * this.toRads(20.0f);
            this.rightWing1.yRot = -Mth.sin((float)ageInTicks) * this.toRads(20.0f);
        } else {
            this.leftWing1.yRot = 0.0f;
            this.rightWing1.yRot = 0.0f;
        }
        float petTimer = (float)entityIn.getPetTimer() + partialTick;
        float petDuration = 20.0f;
        if (petTimer < petDuration) {
            this.tail1.zRot = Mth.sin((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.tail2.zRot = Mth.sin((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.tail3.zRot = Mth.sin((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(20.0f);
            this.jaw.zRot = -Mth.sin((float)(petTimer / petDuration * (float)Math.PI * 6.0f)) * this.toRads(10.0f);
        }
        if (entityIn.swinging) {
            float attackProgress = entityIn.getAttackProgress(partialTick);
            this.tail1.yRot = Mth.sin((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
            this.tail2.yRot = Mth.sin((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
            this.tail3.yRot = Mth.sin((float)(attackProgress * (float)Math.PI * 4.0f)) * this.toRads(30.0f);
        } else {
            this.tail1.yRot = 0.0f;
            this.tail2.yRot = 0.0f;
            this.tail3.yRot = 0.0f;
        }
        if (!entityIn.isSitting()) {
            this.leftLeg1.xRot = this.toRads(25.0f) + Mth.cos((float)(limbSwing * 0.7f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.rightLeg1.xRot = this.toRads(25.0f) + Mth.cos((float)(limbSwing * 0.7f)) * limbSwingAmount * 0.5f;
            this.leftLeg3.xRot = this.toRads(23.0f);
            this.rightLeg3.xRot = this.toRads(23.0f);
            float flyingTimer = entityIn.getFlyingTimer(partialTick);
            float wingspan = entityIn.getWingspan(partialTick);
            float flyingWingRot = flyingTimer * 1.15f;
            this.leftWing1.zRot = this.toRads(65.0f) + Mth.cos((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan));
            this.leftWing2.zRot = this.toRads(50.0f) + Mth.cos((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan) * 0.5f);
            this.rightWing1.zRot = -this.toRads(65.0f) - Mth.cos((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan));
            this.rightWing2.zRot = -this.toRads(50.0f) - Mth.cos((float)(limbSwing * 0.7f + flyingWingRot)) * (limbSwingAmount * 0.2f + this.toRads(wingspan) * 0.5f);
            this.tail1.xRot = Mth.cos((float)(ageInTicks / 20.0f)) * this.toRads(10.0f);
            this.tail2.xRot = Mth.cos((float)(ageInTicks / 20.0f)) * this.toRads(10.0f);
            this.tail3.xRot = Mth.cos((float)(ageInTicks / 20.0f)) * this.toRads(10.0f);
            this.body.xRot = this.toRads(-4.0f);
            this.neck1.xRot = this.toRads(-30.0f);
            this.neck2.xRot = this.toRads(-9.0f);
        } else {
            this.leftLeg1.xRot = this.toRads(15.0f);
            this.rightLeg1.xRot = this.toRads(15.0f);
            this.leftLeg3.xRot = this.toRads(26.0f);
            this.rightLeg3.xRot = this.toRads(26.0f);
            this.leftWing1.zRot = this.toRads(150.0f);
            this.leftWing2.zRot = this.toRads(20.0f);
            this.rightWing1.zRot = -this.toRads(150.0f);
            this.rightWing2.zRot = -this.toRads(20.0f);
            this.tail1.xRot = this.toRads(30.0f);
            this.tail2.xRot = this.toRads(30.0f);
            this.tail3.xRot = this.toRads(30.0f);
            this.body.xRot = this.toRads(-50.0f);
            this.neck1.xRot = this.toRads(10.0f);
            this.neck2.xRot = this.toRads(5.0f);
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(DragonFamiliarEntity entityIn) {
        boolean hasEars = entityIn.hasEars();
        boolean hasArms = entityIn.hasArms();
        this.fez1.visible = entityIn.hasFez();
        this.leftEar.visible = hasEars;
        this.rightEar.visible = hasEars;
        this.leftHorn1.visible = !hasEars;
        this.rightHorn1.visible = !hasEars;
        this.leftArm1.visible = hasArms;
        this.rightArm1.visible = hasArms;
    }

    private void setEyeColor(float r, float g, float b) {
        this.leftEye.setColor(r, g, b);
        this.rightEye.setColor(r, g, b);
    }

    public static class ColorModelPartProxy
    extends ModelPart {
        Color color;
        ModelPart proxied;

        public ColorModelPartProxy(ModelPart modelPart) {
            super(Collections.emptyList(), Collections.emptyMap());
            this.proxied = modelPart;
        }

        public void setColor(float r, float g, float b) {
            this.setColor(r, g, b, 1.0f);
        }

        public void setColor(float r, float g, float b, float a) {
            this.color = Color.ofRGBA((float)r, (float)g, (float)b, (float)a);
        }

        public void render(PoseStack poseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, int pColor) {
            this.proxied.render(poseStack, pVertexConsumer, pPackedLight, pPackedOverlay, this.color.getColor());
        }

        public void proxyRender(PoseStack poseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, int pColor) {
            this.proxied.render(poseStack, pVertexConsumer, pPackedLight, pPackedOverlay, this.color.getColor());
        }

        public PartPose getInitialPose() {
            return this.proxied.getInitialPose();
        }

        public void visit(PoseStack pPoseStack, ModelPart.Visitor pVisitor) {
            this.proxied.visit(pPoseStack, pVisitor);
        }

        public void offsetPos(Vector3f p_233565_) {
            this.proxied.offsetPos(p_233565_);
        }

        public void offsetRotation(Vector3f p_233568_) {
            this.proxied.offsetRotation(p_233568_);
        }

        public void offsetScale(Vector3f p_233571_) {
            this.proxied.offsetScale(p_233571_);
        }

        public Stream<ModelPart> getAllParts() {
            return this.proxied.getAllParts();
        }

        public PartPose storePose() {
            return this.proxied.storePose();
        }

        public void setInitialPose(PartPose pInitialPose) {
            this.proxied.setInitialPose(pInitialPose);
        }

        public void resetPose() {
            this.proxied.resetPose();
        }

        public void loadPose(PartPose pPartPose) {
            this.proxied.loadPose(pPartPose);
        }

        public void copyFrom(ModelPart pModelPart) {
            this.proxied.copyFrom(pModelPart);
        }

        public boolean hasChild(String p_233563_) {
            return this.proxied.hasChild(p_233563_);
        }

        public ModelPart getChild(String pName) {
            return this.proxied.getChild(pName);
        }

        public void setPos(float pX, float pY, float pZ) {
            this.proxied.setPos(pX, pY, pZ);
        }

        public void setRotation(float pXRot, float pYRot, float pZRot) {
            this.proxied.setRotation(pXRot, pYRot, pZRot);
        }

        public void translateAndRotate(PoseStack pPoseStack) {
            this.proxied.translateAndRotate(pPoseStack);
        }

        public ModelPart.Cube getRandomCube(RandomSource pRandom) {
            return this.proxied.getRandomCube(pRandom);
        }

        public boolean isEmpty() {
            return this.proxied.isEmpty();
        }
    }
}

