/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GuardianFamiliarModel
extends EntityModel<GuardianFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart bodyLower;
    public ModelPart head;
    public ModelPart leftArm1;
    public ModelPart rightArm1;
    public ModelPart leftLeg1;
    public ModelPart rightLeg1;
    public ModelPart leftLeg2;
    public ModelPart rightLeg2;
    public ModelPart crystal1;
    public ModelPart crystal2;
    public ModelPart crystal3;
    public ModelPart leftEye;
    public ModelPart rightEye;
    public ModelPart tree1;
    public ModelPart tree2;
    public ModelPart leftArm2;
    public ModelPart birdBody;
    public ModelPart leftArm3;
    public ModelPart birdLeftLeg;
    public ModelPart birdRightLeg;
    public ModelPart birdHead;
    public ModelPart birdLeftWing;
    public ModelPart birdRightWing;
    public ModelPart birdNose;
    public ModelPart rightArm2;
    public ModelPart rightArm3;

    public GuardianFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.bodyLower = this.body.getChild("bodyLower");
        this.head = this.body.getChild("head");
        this.leftArm1 = this.body.getChild("leftArm1");
        this.rightArm1 = this.body.getChild("rightArm1");
        this.leftLeg1 = this.bodyLower.getChild("leftLeg1");
        this.rightLeg1 = this.bodyLower.getChild("rightLeg1");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.crystal1 = this.head.getChild("crystal1");
        this.crystal2 = this.head.getChild("crystal2");
        this.crystal3 = this.head.getChild("crystal3");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.tree1 = this.head.getChild("tree1");
        this.tree2 = this.head.getChild("tree2");
        this.leftArm2 = this.leftArm1.getChild("leftArm2");
        this.birdBody = this.leftArm1.getChild("birdBody");
        this.leftArm3 = this.leftArm2.getChild("leftArm3");
        this.birdLeftLeg = this.birdBody.getChild("birdLeftLeg");
        this.birdRightLeg = this.birdBody.getChild("birdRightLeg");
        this.birdHead = this.birdBody.getChild("birdHead");
        this.birdLeftWing = this.birdBody.getChild("birdLeftWing");
        this.birdRightWing = this.birdBody.getChild("birdRightWing");
        this.birdNose = this.birdHead.getChild("birdNose");
        this.rightArm2 = this.rightArm1.getChild("rightArm2");
        this.rightArm3 = this.rightArm2.getChild("rightArm3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -3.0f, 7.0f, 6.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)9.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyLower = body.addOrReplaceChild("bodyLower", CubeListBuilder.create().texOffs(26, 0).addBox(-2.5f, -2.0f, -2.5f, 5.0f, 4.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(22, 9).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.addOrReplaceChild("leftArm1", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, false), PartPose.offsetAndRotation((float)5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.19547687f));
        PartDefinition rightArm1 = body.addOrReplaceChild("rightArm1", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, true), PartPose.offsetAndRotation((float)-5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.19198622f));
        PartDefinition leftLeg1 = bodyLower.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(46, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1563815f));
        PartDefinition rightLeg1 = bodyLower.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(46, 0).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1563815f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.11728612f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(20, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.11728612f));
        PartDefinition crystal1 = head.addOrReplaceChild("crystal1", CubeListBuilder.create().texOffs(8, 28).addBox(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.9f, (float)-1.0f, (float)0.0f, (float)-0.07819075f, (float)-0.35185838f, (float)0.43004912f));
        PartDefinition crystal2 = head.addOrReplaceChild("crystal2", CubeListBuilder.create().texOffs(4, 28).addBox(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)-1.0f, (float)-1.0f, (float)0.1563815f, (float)0.23457225f, (float)0.19547687f));
        PartDefinition crystal3 = head.addOrReplaceChild("crystal3", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)-1.1f, (float)-1.0f, (float)1.0f, (float)-0.11728612f, (float)0.8210029f, (float)-0.23457225f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.2f, (float)-0.5f, (float)-2.4f, (float)0.0f, (float)-0.12217305f, (float)0.12217305f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, true), PartPose.offsetAndRotation((float)-1.2f, (float)-0.5f, (float)-2.4f, (float)0.0f, (float)0.12217305f, (float)-0.12217305f));
        PartDefinition tree1 = head.addOrReplaceChild("tree1", CubeListBuilder.create().texOffs(12, 22).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition tree2 = head.addOrReplaceChild("tree2", CubeListBuilder.create().texOffs(12, 22).addBox(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        PartDefinition leftArm2 = leftArm1.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(35, 16).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.07819075f));
        PartDefinition birdBody = leftArm1.addOrReplaceChild("birdBody", CubeListBuilder.create().texOffs(56, 28).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.3f, (float)-2.9f, (float)0.0f, (float)-0.54733527f, (float)0.17453292f, (float)0.0f));
        PartDefinition leftArm3 = leftArm2.addOrReplaceChild("leftArm3", CubeListBuilder.create().texOffs(52, 13).addBox(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.039095376f));
        PartDefinition birdLeftLeg = birdBody.addOrReplaceChild("birdLeftLeg", CubeListBuilder.create().texOffs(48, 30).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)-0.31f, (float)0.0f, (float)0.74281216f, (float)-0.51173055f, (float)-0.43004912f));
        PartDefinition birdRightLeg = birdBody.addOrReplaceChild("birdRightLeg", CubeListBuilder.create().texOffs(48, 30).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)-0.4f, (float)-0.21f, (float)0.0f, (float)0.7330383f, (float)0.5235988f, (float)0.41887903f));
        PartDefinition birdHead = birdBody.addOrReplaceChild("birdHead", CubeListBuilder.create().texOffs(44, 30).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-0.6f, (float)0.50823987f, (float)0.0f, (float)0.0f));
        PartDefinition birdLeftWing = birdBody.addOrReplaceChild("birdLeftWing", CubeListBuilder.create().texOffs(50, 30).addBox(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.7f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)-0.39095375f, (float)0.50823987f));
        PartDefinition birdRightWing = birdBody.addOrReplaceChild("birdRightWing", CubeListBuilder.create().texOffs(50, 30).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, true), PartPose.offsetAndRotation((float)-0.7f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.39095375f, (float)-0.50823987f));
        PartDefinition birdNose = birdHead.addOrReplaceChild("birdNose", CubeListBuilder.create().texOffs(41, 31).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.3f, (float)-0.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm2 = rightArm1.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(35, 16).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.07819075f));
        PartDefinition rightArm3 = rightArm2.addOrReplaceChild("rightArm3", CubeListBuilder.create().texOffs(52, 13).addBox(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, true), PartPose.offsetAndRotation((float)1.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.039095376f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
        if (!this.leftArm1.visible) {
            pPoseStack.pushPose();
            pPoseStack.translate((double)this.body.x / 16.0, (double)this.body.y / 16.0, (double)this.body.z / 16.0);
            pPoseStack.translate(0.35, -0.2, 0.0);
            this.birdBody.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            pPoseStack.popPose();
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    public void setupAnim(GuardianFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.showModels(pEntity);
        byte lives = pEntity.getLives();
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.body.zRot = 0.0f;
        this.rightLeg1.zRot = 0.16f;
        this.rightArm1.zRot = 0.19f;
        if (pEntity.isSitting()) {
            this.rightLeg1.xRot = this.toRads(-90.0f);
            this.leftLeg1.xRot = this.toRads(-90.0f);
            this.leftArm1.xRot = this.toRads(-30.0f);
            this.rightArm1.xRot = this.toRads(-30.0f);
            this.leftArm2.xRot = this.toRads(-30.0f);
            this.rightArm2.xRot = this.toRads(-30.0f);
            this.leftArm3.xRot = this.toRads(-30.0f);
            this.rightArm3.xRot = this.toRads(-30.0f);
        } else {
            this.rightLeg1.xRot = Mth.cos((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.5f;
            this.leftLeg1.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.leftArm2.xRot = 0.0f;
            this.rightArm2.xRot = 0.0f;
            this.leftArm3.xRot = 0.0f;
            this.rightArm3.xRot = 0.0f;
        }
        if (pEntity.isPartying()) {
            this.leftArm1.xRot = -pAgeInTicks / 10.0f;
            this.rightArm1.xRot = -pAgeInTicks / 10.0f;
            this.head.yRot = pAgeInTicks / 10.0f;
        } else if (!pEntity.isSitting()) {
            this.rightArm1.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.leftArm1.xRot = Mth.cos((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.5f;
        }
        if (lives == 3) {
            this.body.zRot = this.toRads(-20.0f);
            this.rightLeg1.zRot = this.toRads(20.0f);
            this.rightArm1.zRot = this.toRads(20.0f);
        }
        this.birdHead.yRot = netHeadYaw * ((float)Math.PI / 180) * 0.4f;
        this.birdHead.xRot = headPitch * ((float)Math.PI / 180) * 0.4f + this.toRads(30.0f);
        if (lives > 4) {
            this.birdLeftLeg.y = -(Mth.sin((float)(pAgeInTicks / 2.0f)) + 1.0f) * 0.1f - 0.21f;
            this.birdRightLeg.y = -(Mth.sin((float)(pAgeInTicks / 2.0f + (float)Math.PI)) + 1.0f) * 0.1f - 0.21f;
            if (pAgeInTicks % 100.0f < 20.0f) {
                float wingProgress = pAgeInTicks % 100.0f % 20.0f;
                this.birdLeftWing.zRot = this.toRads(20.0f) + Mth.sin((float)(wingProgress / 20.0f * this.toRads(360.0f) * 2.0f)) * this.toRads(25.0f);
                this.birdRightWing.zRot = this.toRads(-20.0f) - Mth.sin((float)(wingProgress / 20.0f * this.toRads(360.0f) * 2.0f)) * this.toRads(25.0f);
            }
            this.birdBody.y = -2.9f;
        } else {
            this.birdLeftLeg.y = -0.31f;
            this.birdRightLeg.y = -0.31f;
            this.birdLeftWing.zRot = this.toRads(20.0f) + Mth.sin((float)(pAgeInTicks / 2.0f)) * this.toRads(25.0f);
            this.birdRightWing.zRot = this.toRads(-20.0f) - Mth.sin((float)(pAgeInTicks / 2.0f)) * this.toRads(25.0f);
            this.birdBody.y = -2.9f - Mth.sin((float)(pAgeInTicks / 2.0f)) * 0.4f;
            this.birdBody.zRot = lives <= 3 ? 0.0f : 0.0f;
        }
    }

    private void showModels(GuardianFamiliarEntity entity) {
        boolean hasTree = entity.hasTree();
        byte lives = entity.getLives();
        this.tree1.visible = hasTree;
        this.tree2.visible = hasTree;
        this.birdBody.visible = entity.hasBird();
        this.leftArm1.visible = lives > 4;
        this.leftLeg1.visible = lives > 3;
        this.rightLeg1.visible = lives > 2;
        this.rightArm1.visible = lives > 1;
    }
}

