/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.blockentity;

import com.klikli_dev.occultism.common.block.EntityWormholeBlock;
import com.klikli_dev.occultism.common.blockentity.EntityWormholeBlockEntity;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class EntityWormholeRenderer
implements BlockEntityRenderer<EntityWormholeBlockEntity> {
    public EntityWormholeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EntityWormholeBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        double yOffset;
        double xOffset;
        float f;
        ItemStackHandler handler = blockEntity.itemStackHandler;
        ItemStack stack = handler.getStackInSlot(0) == ItemStack.EMPTY ? ItemStack.EMPTY : OccultismItems.WORMHOLE_PORTAL.toStack();
        ItemStack stackNugget = OccultismItems.IESNIUM_NUGGET.toStack();
        BlockState state = blockEntity.getBlockState();
        Direction facing = state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : Direction.UP;
        int exitY = state.hasProperty((Property)EntityWormholeBlock.EXIT_ROTATION_Y) ? (Integer)state.getValue((Property)EntityWormholeBlock.EXIT_ROTATION_Y) : 0;
        int exitX = state.hasProperty((Property)EntityWormholeBlock.EXIT_ROTATION_X) ? (Integer)state.getValue((Property)EntityWormholeBlock.EXIT_ROTATION_X) : 0;
        Block block = state.getBlock();
        if (block instanceof EntityWormholeBlock) {
            EntityWormholeBlock wormholeBlock = (EntityWormholeBlock)block;
            f = wormholeBlock.getExitRotY(state);
        } else {
            f = 0.0f;
        }
        float angleY = f;
        poseStack.pushPose();
        poseStack.pushPose();
        double d = facing.getAxis() == Direction.Axis.X ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 0.03 : 0.97) : (xOffset = 0.5);
        double d2 = facing.getAxis() == Direction.Axis.Y ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 0.03 : 0.97) : (yOffset = 0.5);
        double zOffset = facing.getAxis() == Direction.Axis.Z ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 0.03 : 0.97) : 0.5;
        poseStack.translate(xOffset, yOffset, zOffset);
        float angle = facing.getAxis() == Direction.Axis.X ? 90.0f : 0.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(angle));
        float angle2 = facing.getAxis() == Direction.Axis.Y ? 90.0f : 0.0f;
        poseStack.mulPose(Axis.XP.rotationDegrees(angle2));
        poseStack.scale(0.1f, 0.1f, 0.1f);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel modelNugget = itemRenderer.getModel(stackNugget, blockEntity.getLevel(), null, 0);
        if (exitY != 0) {
            Vec3 vec3;
            if (facing.getAxis() == Direction.Axis.Y) {
                vec3 = Vec3.directionFromRotation((float)0.0f, (float)((angleY + 180.0f) * 0.002f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(angleY + 180.0f));
            } else {
                vec3 = Vec3.directionFromRotation((float)0.0f, (float)(angleY * 0.002f));
                poseStack.mulPose(Axis.ZN.rotationDegrees(angleY));
            }
            float nuggetOffset = facing.getAxis() == Direction.Axis.Y ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? -0.3f : 0.3f) : (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 0.3f : -0.3f);
            poseStack.translate(-4.0 * vec3.x, -4.0 * vec3.z, (double)nuggetOffset);
            itemRenderer.render(stackNugget, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, modelNugget);
            poseStack.translate(4.0 * vec3.x, 4.0 * vec3.z, (double)(-nuggetOffset));
        }
        if (exitX != 0) {
            ItemStack stackBlock = switch (exitX) {
                case 2 -> new ItemStack((ItemLike)Items.IRON_BLOCK);
                case 3 -> new ItemStack((ItemLike)Items.REDSTONE_BLOCK);
                case 4 -> new ItemStack((ItemLike)Items.DIAMOND_BLOCK);
                case 5 -> new ItemStack((ItemLike)Items.GOLD_BLOCK);
                default -> new ItemStack((ItemLike)Items.EMERALD_BLOCK);
            };
            poseStack.scale(0.25f, 0.25f, 0.25f);
            float blockOffset = facing.getAxis() == Direction.Axis.Y ? (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? -0.7f : 0.7f) : (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 0.7f : -0.7f);
            poseStack.translate(0.0f, 0.0f, blockOffset);
            BakedModel modelBlock = itemRenderer.getModel(stackBlock, blockEntity.getLevel(), null, 0);
            itemRenderer.render(stackBlock, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, modelBlock);
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            itemRenderer.render(stackBlock, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, modelBlock);
            poseStack.translate(0.0f, 0.0f, -blockOffset);
            poseStack.scale(4.0f, 4.0f, 4.0f);
        }
        long systemTime = System.currentTimeMillis();
        float angle3 = systemTime / 16L % 360L;
        poseStack.mulPose(Axis.ZP.rotationDegrees(angle3));
        poseStack.scale(7.0f, 7.0f, 7.0f);
        BakedModel model = itemRenderer.getModel(stack, blockEntity.getLevel(), null, 0);
        itemRenderer.render(stack, ItemDisplayContext.FIXED, true, poseStack, buffer, combinedLight, combinedOverlay, model);
        poseStack.popPose();
        poseStack.mulPose(facing.getRotation());
        poseStack.popPose();
    }
}

