/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class EntityWormholeBlockEntity
extends NetworkedBlockEntity {
    public long lastChangeTime;
    public ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            Level level = EntityWormholeBlockEntity.this.level;
            if (level != null && !level.isClientSide) {
                EntityWormholeBlockEntity.this.lastChangeTime = level.getGameTime();
                EntityWormholeBlockEntity.this.setChanged();
                EntityWormholeBlockEntity.this.markNetworkDirty();
            }
        }
    };
    protected boolean initialized = false;

    public EntityWormholeBlockEntity(BlockPos worldPos, BlockState state) {
        super(OccultismBlockEntities.ENTITY_WORMHOLE.get(), worldPos, state);
        this.itemStackHandler = new ItemStackHandler(1){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack.is(ItemTags.COMPASSES) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                if (!((EntityWormholeBlockEntity)EntityWormholeBlockEntity.this).level.isClientSide) {
                    EntityWormholeBlockEntity.this.lastChangeTime = EntityWormholeBlockEntity.this.level.getGameTime();
                    EntityWormholeBlockEntity.this.markNetworkDirty();
                }
            }
        };
    }

    public EntityWormholeBlockEntity(BlockEntityType<?> BlockEntityTypeIn, BlockPos worldPos, BlockState state) {
        super(BlockEntityTypeIn, worldPos, state);
    }

    @Override
    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        this.itemStackHandler.deserializeNBT(provider, compound.getCompound("inventory"));
        this.lastChangeTime = compound.getLong("lastChangeTime");
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("inventory", (Tag)this.itemStackHandler.serializeNBT(provider));
        compound.putLong("lastChangeTime", this.lastChangeTime);
        return compound;
    }
}

