/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class ResizableFamiliarEntity
extends FamiliarEntity {
    protected static final byte MAX_SIZE = 100;
    private static final EntityDataAccessor<Byte> SIZE = SynchedEntityData.defineId(ResizableFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public ResizableFamiliarEntity(EntityType<? extends ResizableFamiliarEntity> type, Level level) {
        super(type, level);
    }

    public byte getSize() {
        return (Byte)this.entityData.get(SIZE);
    }

    public void setSize(byte size) {
        this.entityData.set(SIZE, (Object)((byte)Mth.clamp((int)size, (int)0, (int)100)));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSize(compound.getByte("getSize"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("getSize", this.getSize());
    }

    public float getScale() {
        return 1.0f + (float)this.getSize() * 1.0f / 100.0f;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (SIZE.equals(pKey)) {
            this.refreshDimensions();
        }
    }
}

