/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BoundBookOfBindingRecipe
extends CustomRecipe {
    public static RecipeSerializer<BoundBookOfBindingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(BoundBookOfBindingRecipe::new);

    public BoundBookOfBindingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, @NotNull Level level) {
        int i = 0;
        ItemStack dictionaryOfSpirits = ItemStack.EMPTY;
        ItemStack bookOfBinding = ItemStack.EMPTY;
        for (int j = 0; j < input.size(); ++j) {
            ItemStack inputStack = input.getItem(j);
            if (inputStack.isEmpty()) continue;
            if (inputStack.is(OccultismItems.DICTIONARY_OF_SPIRITS)) {
                if (!dictionaryOfSpirits.isEmpty()) {
                    return false;
                }
                dictionaryOfSpirits = inputStack;
                continue;
            }
            if (!inputStack.is(OccultismTags.Items.BOOKS_OF_BINDING)) {
                return false;
            }
            if (!bookOfBinding.isEmpty()) {
                return false;
            }
            bookOfBinding = inputStack;
            ++i;
        }
        return !dictionaryOfSpirits.isEmpty() && !bookOfBinding.isEmpty() && i > 0;
    }

    @NotNull
    public ItemStack assemble(CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        int i = 0;
        ItemStack dictionaryOfSpirits = ItemStack.EMPTY;
        ItemStack bookOfBinding = ItemStack.EMPTY;
        for (int j = 0; j < input.size(); ++j) {
            ItemStack inputStack = input.getItem(j);
            if (inputStack.isEmpty()) continue;
            if (inputStack.is(OccultismItems.DICTIONARY_OF_SPIRITS)) {
                if (!dictionaryOfSpirits.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                dictionaryOfSpirits = inputStack;
                continue;
            }
            if (!inputStack.is(OccultismTags.Items.BOOKS_OF_BINDING)) {
                return ItemStack.EMPTY;
            }
            if (!bookOfBinding.isEmpty()) {
                return ItemStack.EMPTY;
            }
            bookOfBinding = inputStack;
            ++i;
        }
        ItemStack boundBook = BoundBookOfBindingRecipe.getBoundBookFromBook(bookOfBinding);
        if (boundBook.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Component customName = (Component)dictionaryOfSpirits.get(DataComponents.CUSTOM_NAME);
        DataComponentMap akashicName = dictionaryOfSpirits.getComponents().filter(comp -> comp.toString().contains("akashictome:og_display_name"));
        if (!akashicName.isEmpty()) {
            String s = ((TypedDataComponent)akashicName.stream().findFirst().get()).value().toString();
            if (s.startsWith("translation")) {
                ItemNBTUtil.generateBoundSpiritName(boundBook);
            } else {
                ItemNBTUtil.setBoundSpiritName(boundBook, s.substring(8, s.length() - 1));
            }
        } else if (customName != null) {
            String s = customName.getContents().toString();
            if (s.equals("translation{key='eccentrictome.name', args=[translation{key='book.occultism.dictionary_of_spirits.name', args=[]}[style={color=green}]]}")) {
                ItemNBTUtil.generateBoundSpiritName(boundBook);
            } else if (s.startsWith("translation{key='eccentrictome.name', args=[literal{") && s.endsWith("}[style={color=green}]]}")) {
                ItemNBTUtil.setBoundSpiritName(boundBook, s.substring(52, s.length() - 24));
            } else {
                ItemNBTUtil.setBoundSpiritName(boundBook, customName.getString());
            }
        } else {
            ItemNBTUtil.generateBoundSpiritName(boundBook);
        }
        return boundBook;
    }

    public static ItemStack getBoundBookFromBook(ItemStack book) {
        if (book.is(OccultismItems.BOOK_OF_BINDING_FOLIOT)) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get());
        }
        if (book.is(OccultismItems.BOOK_OF_BINDING_DJINNI)) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get());
        }
        if (book.is(OccultismItems.BOOK_OF_BINDING_AFRIT)) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get());
        }
        if (book.is(OccultismItems.BOOK_OF_BINDING_MARID)) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get());
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack bookshelfCraft(ItemStack book, ItemStack dictionary) {
        ItemStack boundBook = BoundBookOfBindingRecipe.getBoundBookFromBook(book);
        Component customName = (Component)dictionary.get(DataComponents.CUSTOM_NAME);
        DataComponentMap akashicName = dictionary.getComponents().filter(comp -> comp.toString().contains("akashictome:og_display_name"));
        if (!akashicName.isEmpty()) {
            String s = ((TypedDataComponent)akashicName.stream().findFirst().get()).value().toString();
            if (s.startsWith("translation")) {
                ItemNBTUtil.generateBoundSpiritName(boundBook);
            } else {
                ItemNBTUtil.setBoundSpiritName(boundBook, s.substring(8, s.length() - 1));
            }
        } else if (customName != null) {
            String s = customName.getContents().toString();
            if (s.equals("translation{key='eccentrictome.name', args=[translation{key='book.occultism.dictionary_of_spirits.name', args=[]}[style={color=green}]]}")) {
                ItemNBTUtil.generateBoundSpiritName(boundBook);
            } else if (s.startsWith("translation{key='eccentrictome.name', args=[literal{") && s.endsWith("}[style={color=green}]]}")) {
                ItemNBTUtil.setBoundSpiritName(boundBook, s.substring(52, s.length() - 24));
            } else {
                ItemNBTUtil.setBoundSpiritName(boundBook, customName.getString());
            }
        } else {
            ItemNBTUtil.generateBoundSpiritName(boundBook);
        }
        return boundBook;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)OccultismRecipes.BOOK_BINDING.get();
    }
}

