/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetJumps;
import com.klikli_dev.occultism.registry.OccultismDataStorage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="occultism", bus=EventBusSubscriber.Bus.GAME)
public class CapabilityEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post evt) {
        if (evt.getEntity().onGround()) {
            evt.getEntity().setData(OccultismDataStorage.DOUBLE_JUMP, (Object)0);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent evt) {
        ServerPlayer player;
        int jumps;
        Entity entity = evt.getEntity();
        if (entity instanceof ServerPlayer && (jumps = ((Integer)(player = (ServerPlayer)entity).getData(OccultismDataStorage.DOUBLE_JUMP)).intValue()) > 0) {
            Networking.sendTo(player, new MessageSetJumps(jumps));
        }
    }
}

