/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl;

import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetRecipe;
import com.klikli_dev.occultism.network.messages.MessageSetRecipeByID;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class StorageControllerRecipeTransferHandler<T extends AbstractContainerMenu>
implements IRecipeTransferHandler<T, RecipeHolder<CraftingRecipe>> {
    protected final Class<T> containerClass;
    protected final IRecipeTransferHandlerHelper handlerHelper;

    public StorageControllerRecipeTransferHandler(Class<T> containerClass, IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.containerClass = containerClass;
    }

    public CompoundTag recipeToNbt(AbstractContainerMenu container, IRecipeSlotsView recipeSlots) {
        CompoundTag nbt = new CompoundTag();
        List slotsViewList = recipeSlots.getSlotViews();
        for (Slot slot : container.slots) {
            List possibleItems;
            IRecipeSlotView slotView;
            if (!(slot.container instanceof CraftingContainer) || (slotView = (IRecipeSlotView)slotsViewList.get(slot.getSlotIndex() + 1)) == null || (possibleItems = slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).collect(Collectors.toList())).isEmpty()) continue;
            ListTag invList = new ListTag();
            for (int i = 0; i < possibleItems.size() && i < 5; ++i) {
                ItemStack itemStack = (ItemStack)possibleItems.get(i);
                if (itemStack.isEmpty()) continue;
                invList.add((Object)itemStack.saveOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
            }
            nbt.put("s" + slot.getSlotIndex(), (Tag)invList);
        }
        return nbt;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    public IRecipeTransferError transferRecipe(T container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.id() == null) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"jei.occultismerror.missing_id"));
        }
        if (!((CraftingRecipe)recipe.value()).canCraftInDimensions(3, 3)) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"jei.occultismerror.recipe_too_large"));
        }
        if (doTransfer) {
            if (player.getCommandSenderWorld().getRecipeManager().byKey(recipe.id()).isPresent()) {
                Networking.sendToServer(new MessageSetRecipeByID(recipe.id()));
            } else {
                Networking.sendToServer(new MessageSetRecipe(this.recipeToNbt((AbstractContainerMenu)container, recipeSlots)));
            }
        }
        return null;
    }
}

