/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl.recipes;

import com.klikli_dev.occultism.crafting.recipe.CrystallizeRecipe;
import com.klikli_dev.occultism.integration.jei.impl.JeiRecipeTypes;
import com.klikli_dev.occultism.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CrystallizeRecipeCategory
implements IRecipeCategory<RecipeHolder<CrystallizeRecipe>> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;

    public CrystallizeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 56);
        this.localizedName = Component.translatable((String)"occultism.jei.crystallize");
        this.overlay = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, Component text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.width((FormattedText)text) / 2.0f, (float)y, 0, false);
    }

    public RecipeType<RecipeHolder<CrystallizeRecipe>> getRecipeType() {
        return JeiRecipeTypes.CRYSTALLIZE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CrystallizeRecipe> recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 12).addIngredients((Ingredient)((CrystallizeRecipe)recipe.value()).getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 12).addItemStack(((CrystallizeRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void draw(RecipeHolder<CrystallizeRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(guiGraphics, 76, 14);
        this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, this.getTitle(), 84, 0);
        int y = 35;
        if (((CrystallizeRecipe)recipe.value()).getMinTier() >= 0) {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.crystallize.min_tier", (Object[])new Object[]{((CrystallizeRecipe)recipe.value()).getMinTier()}), 84, y);
            y += 10;
        }
        if (((CrystallizeRecipe)recipe.value()).getMaxTier() >= 0) {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.crystallize.max_tier", (Object[])new Object[]{((CrystallizeRecipe)recipe.value()).getMaxTier()}), 84, y);
        }
    }
}

