/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Math3DUtil {
    public static double yaw(Vec3 a, Vec3 b) {
        double dirx = a.x - b.x;
        double diry = a.y - b.y;
        double dirz = a.z - b.z;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        double pitch = Math.asin(diry /= len);
        double yaw = Math.atan2(dirz /= len, dirx /= len);
        pitch = pitch * 180.0 / Math.PI;
        yaw = yaw * 180.0 / Math.PI;
        return yaw += 90.0;
    }

    public static Vec3 center(BlockPos pos) {
        return new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
    }

    public static BlockPos clamp(BlockPos pos, AABB bounds) {
        return BlockPos.containing((double)Mth.clamp((double)pos.getX(), (double)bounds.minX, (double)bounds.maxX), (double)Mth.clamp((double)pos.getY(), (double)bounds.minY, (double)bounds.maxY), (double)Mth.clamp((double)pos.getZ(), (double)bounds.minZ, (double)bounds.maxZ));
    }

    public static AABB bounds(ChunkPos pos, int maxHeight) {
        return new AABB((double)pos.getMinBlockX(), 0.0, (double)pos.getMinBlockZ(), (double)pos.getMaxBlockX(), (double)maxHeight, (double)pos.getMaxBlockZ());
    }

    public static List<BlockPos> simpleTrace(BlockPos start, Direction direction, int distance) {
        return BlockPos.betweenClosedStream((BlockPos)start, (BlockPos)start.relative(direction, distance)).map(BlockPos::immutable).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)start).distSqr(arg_0))).collect(Collectors.toList());
    }

    public static BlockPos simpleTrace(BlockPos start, Direction direction, int distance, Predicate<BlockPos> hitCondition) {
        List<BlockPos> positions = Math3DUtil.simpleTrace(start, direction, distance);
        for (BlockPos pos : positions) {
            if (!hitCondition.test(pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean withinAxisDistances(Vec3 a, Vec3 b, double distanceX, double distanceY, double distanceZ) {
        double d0 = Math.abs(a.x - b.x);
        double d1 = Math.abs(a.y - b.y);
        double d2 = Math.abs(a.z - b.z);
        return d0 <= distanceX && d1 <= distanceY && d2 <= distanceZ;
    }
}

