/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.network.Networking;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class StorageUtil {
    public static void clearOpenCraftingMatrix(ServerPlayer player, boolean sendStackUpdate) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IStorageControllerContainer) {
            IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
            CraftingContainer craftMatrix = container.getCraftMatrix();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                int remainingAfterInsert;
                int amountBeforeInsert;
                ItemStack stackInSlot = craftMatrix.getItem(i);
                if (stackInSlot.isEmpty() || (amountBeforeInsert = stackInSlot.getCount()) == (remainingAfterInsert = storageController.insertStack(stackInSlot.copy(), false))) continue;
                if (remainingAfterInsert == 0) {
                    craftMatrix.setItem(i, ItemStack.EMPTY);
                    continue;
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.copyWithCount(remainingAfterInsert));
                craftMatrix.setItem(i, ItemStack.EMPTY);
            }
            if (sendStackUpdate) {
                Networking.sendTo(player, storageController.getMessageUpdateStacks());
                ((AbstractContainerMenu)container).broadcastChanges();
            }
            container.updateCraftingSlots(true);
        }
    }

    public static void clearOpenOrderSlot(ServerPlayer player, boolean sendStackUpdate) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof IStorageControllerContainer) {
            int remainingAfterInsert;
            int amountBeforeInsert;
            IStorageControllerContainer container = (IStorageControllerContainer)abstractContainerMenu;
            SimpleContainer orderSlot = container.getOrderSlot();
            IStorageController storageController = container.getStorageController();
            if (storageController == null) {
                return;
            }
            ItemStack stackInSlot = orderSlot.getItem(0);
            if (!stackInSlot.isEmpty() && (amountBeforeInsert = stackInSlot.getCount()) != (remainingAfterInsert = storageController.insertStack(stackInSlot.copy(), false))) {
                if (remainingAfterInsert == 0) {
                    orderSlot.setItem(0, ItemStack.EMPTY);
                } else {
                    orderSlot.setItem(0, stackInSlot.copyWithCount(remainingAfterInsert));
                }
            }
            if (sendStackUpdate) {
                Networking.sendTo(player, storageController.getMessageUpdateStacks());
                ((AbstractContainerMenu)container).broadcastChanges();
            }
        }
    }

    public static ItemStack extractItem(IItemHandler itemHandler, Predicate<ItemStack> comparator, int amount, boolean simulate) {
        if (itemHandler == null || comparator == null) {
            return ItemStack.EMPTY;
        }
        int amountExtracted = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extractedStack;
            ItemStack slot = itemHandler.getStackInSlot(i);
            if (!comparator.test(slot) || (extractedStack = itemHandler.extractItem(i, 1, simulate)).isEmpty()) continue;
            if (++amountExtracted == amount) {
                return slot.copyWithCount(amount);
            }
            --i;
        }
        return ItemStack.EMPTY;
    }

    public static int getFirstFilledSlot(IItemHandler handler) {
        return StorageUtil.getFirstFilledSlotAfter(handler, -1);
    }

    public static int getFirstFilledSlotAfter(IItemHandler handler, int slot) {
        for (int i = slot + 1; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstMatchingSlot(IItemHandler handler, IItemHandler filter, String tagFilter, boolean isBlacklist) {
        return StorageUtil.getFirstMatchingSlotAfter(handler, -1, filter, tagFilter, isBlacklist);
    }

    public static int getFirstMatchingSlotAfter(IItemHandler handler, int slot, IItemHandler filter, String tagFilter, boolean isBlacklist) {
        for (int i = slot + 1; i < handler.getSlots(); ++i) {
            boolean matches;
            if (handler.getStackInSlot(i).isEmpty()) continue;
            boolean bl = matches = StorageUtil.matchesFilter(handler.getStackInSlot(i), filter) || StorageUtil.matchesFilter(handler.getStackInSlot(i), tagFilter);
            if ((isBlacklist || !matches) && (!isBlacklist || matches)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchesFilter(ItemStack stack, IItemHandler filter) {
        for (int i = 0; i < filter.getSlots(); ++i) {
            ItemStack filtered = filter.getStackInSlot(i);
            boolean equals = ItemStack.isSameItem((ItemStack)filtered, (ItemStack)stack);
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesFilter(ItemStack stack, String tagFilter) {
        String[] filters;
        if (tagFilter.isEmpty()) {
            return false;
        }
        for (String filter : filters = tagFilter.split(";")) {
            if (filter.startsWith("item:")) {
                filter = filter.substring(5);
                if (!FilenameUtils.wildcardMatch((String)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString(), (String)filter, (IOCase)IOCase.INSENSITIVE)) continue;
                return true;
            }
            if (filter.startsWith("tag:")) {
                filter = filter.substring(4);
            }
            String finalFilter = filter;
            boolean equals = stack.getTags().anyMatch(tag -> FilenameUtils.wildcardMatch((String)tag.location().toString(), (String)finalFilter, (IOCase)IOCase.INSENSITIVE));
            if (!equals) continue;
            return true;
        }
        return false;
    }

    public static void dropInventoryItems(BlockEntity blockEntity) {
        IItemHandler handler = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, null);
        if (handler != null) {
            StorageUtil.dropInventoryItems(blockEntity.getLevel(), blockEntity.getBlockPos(), handler);
        }
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemHandler.getStackInSlot(i));
        }
    }

    public static int getFirstMatchingSlot(IItemHandler handler, TagKey<Item> tag) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).is(tag)) continue;
            return i;
        }
        return -1;
    }
}

