/*
 * Decompiled with CFR 0.152.
 */
package com.apeng.zombplayer.capability;

import com.apeng.zombplayer.util.ItemStackIterator;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ZombieInventory
extends ItemStackHandler
implements Iterable<ItemStack> {
    public ZombieInventory() {
    }

    public ZombieInventory(int size) {
        super(size);
    }

    public ZombieInventory(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (ItemStack itemStack : this) {
            builder.append(itemStack).append(", ");
        }
        builder.append("]");
        return builder.toString().strip();
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        return new ItemStackIterator((NonNullList<ItemStack>)this.stacks);
    }

    public void transferAllItemStacks(ZombieInventory targetInventory) {
        this.checkSize(targetInventory);
        for (int i = 0; i < this.getSlots(); ++i) {
            targetInventory.setStackInSlot(i, this.getStackInSlot(i));
            this.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    private void checkSize(ZombieInventory targetInventory) {
        if (this.getSlots() != targetInventory.getSlots()) {
            throw new IllegalArgumentException("The size of target inventory is unmatched.");
        }
    }
}

