/*
 * Decompiled with CFR 0.152.
 */
package com.apeng.zombplayer.event;

import com.apeng.zombplayer.ZombPlayer;
import com.apeng.zombplayer.capability.ZombieInventory;
import com.apeng.zombplayer.gamerule.ZPGameRules;
import com.apeng.zombplayer.mixinduck.InfectedPlayerMark;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.NotNull;

public class ForgeEvents {
    private static final Capability<ZombieInventory> ZOMBIE_INVENTORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ZombieInventory>(){});
    private static ZombieInventory cachedInventory4ConvertingZombie;

    public static void cacheInvBeforeDrownedConversion(LivingConversionEvent.Pre event) {
        if (!ForgeEvents.isZombieDrowned(event) || !ForgeEvents.isZombieInfectedPlayer((LivingEvent)event)) {
            return;
        }
        Zombie zombie = (Zombie)event.getEntity();
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(zombieInventory -> {
            cachedInventory4ConvertingZombie = zombieInventory;
        });
    }

    public static void transferInvOnZombieDrownedConversion(LivingConversionEvent.Post event) {
        if (!ForgeEvents.isZombieDrowned(event) || !ForgeEvents.isZombieInfectedPlayer((LivingEvent)event)) {
            return;
        }
        Zombie zombie = (Zombie)event.getEntity();
        Drowned drowned = (Drowned)event.getOutcome();
        ((InfectedPlayerMark)drowned).setAsInfectedPlayer();
        ForgeEvents.transferInv(drowned);
    }

    private static boolean isZombieInfectedPlayer(LivingEvent event) {
        return ((InfectedPlayerMark)event.getEntity()).isInfectedPlayer();
    }

    private static void transferInv(Drowned drowned) {
        drowned.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(cachedInventory4ConvertingZombie::transferAllItemStacks);
    }

    private static boolean isZombieDrowned(LivingConversionEvent.Pre event) {
        return event.getEntity() instanceof Zombie && event.getOutcome().equals(EntityType.DROWNED);
    }

    private static boolean isZombieDrowned(LivingConversionEvent.Post event) {
        return event.getEntity() instanceof Zombie && event.getOutcome() instanceof Drowned;
    }

    public static void dropInvWhenZombieDies(LivingDropsEvent event) {
        Zombie zombie;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Zombie)) break block4;
                zombie = (Zombie)livingEntity;
                if (ForgeEvents.isZombieInfectedPlayer((LivingEvent)event)) break block5;
            }
            return;
        }
        if (ForgeEvents.isMobLootGameRuleOn(zombie)) {
            ForgeEvents.addZombieInventory2Drops(event, zombie);
        }
        ForgeEvents.invalidateInvCapability(zombie);
    }

    private static boolean isMobLootGameRuleOn(Zombie zombie) {
        return zombie.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
    }

    private static void addZombieInventory2Drops(LivingDropsEvent event, Zombie zombie) {
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(zombieInventory -> zombieInventory.forEach(itemStack -> {
            if (!itemStack.isEmpty()) {
                event.getDrops().add(new ItemEntity(zombie.level(), zombie.getX(), zombie.getEyeY() - (double)0.3f, zombie.getZ(), itemStack));
            }
        }));
    }

    private static void invalidateInvCapability(Zombie zombie) {
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).invalidate();
    }

    public static void attachInventoryCap2Zombie(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Zombie)) {
            return;
        }
        final LazyOptional optionalStorage = LazyOptional.of(() -> new ZombieInventory(36));
        ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction direction) {
                if (cap == ZOMBIE_INVENTORY_CAPABILITY) {
                    return optionalStorage.cast();
                }
                return LazyOptional.empty();
            }

            public CompoundTag serializeNBT() {
                return (CompoundTag)((ZombieInventory)optionalStorage.orElseThrow(() -> new NullPointerException("LazyOptional for zombie/drowned inventory is null."))).serializeNBT();
            }

            public void deserializeNBT(CompoundTag tag) {
                ((ZombieInventory)optionalStorage.orElseThrow(() -> new NullPointerException("LazyOptional for zombie/drowned inventory is null."))).deserializeNBT((Tag)tag);
            }
        };
        event.addCapability(new ResourceLocation("zombplayer", "inventory"), (ICapabilityProvider)provider);
    }

    public static void spawnZombPlayerOnInfected(LivingDeathEvent event) {
        if (!ForgeEvents.isPlayerInfected(event) || !ForgeEvents.shouldPlayerInfected(event)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Zombie zombie = ForgeEvents.spawnPersistantZombie(player);
        player.setInvisible(true);
        if (ForgeEvents.shouldKeepInventory(player)) {
            ForgeEvents.inheritHeadOnly(zombie, player);
        } else {
            ForgeEvents.transferEquipAndInv(zombie, player);
        }
    }

    private static boolean shouldPlayerInfected(LivingDeathEvent event) {
        return event.getEntity().level().getGameRules().getBoolean(ZPGameRules.RULE_DOPLAYERINFECTED);
    }

    private static void inheritHeadOnly(Zombie zombie, ServerPlayer player) {
        ForgeEvents.inheritHead(zombie, player);
        zombie.setDropChance(EquipmentSlot.HEAD, -10.0f);
    }

    private static boolean shouldKeepInventory(ServerPlayer player) {
        return player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
    }

    private static void transferEquipAndInv(Zombie zombie, ServerPlayer player) {
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(zombieInventory -> {
            Inventory playerInventory = player.getInventory();
            ForgeEvents.transferEquipments(zombie, player);
            ForgeEvents.transferInventoryAndLog(zombieInventory, playerInventory);
        });
    }

    private static void transferEquipments(Zombie zombie, ServerPlayer player) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ForgeEvents.transferEquipment(zombie, player, equipmentSlot);
            player.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
    }

    private static void transferEquipment(Zombie zombie, ServerPlayer player, EquipmentSlot equipmentSlot) {
        if (ForgeEvents.shouldInheritHead(player, equipmentSlot)) {
            ForgeEvents.inheritHeadOnly(zombie, player);
        } else {
            ForgeEvents.normalTransfer(zombie, player, equipmentSlot);
        }
    }

    private static void normalTransfer(Zombie zombie, ServerPlayer player, EquipmentSlot equipmentSlot) {
        zombie.setItemSlot(equipmentSlot, player.getItemBySlot(equipmentSlot));
        zombie.setGuaranteedDrop(equipmentSlot);
    }

    private static void inheritHead(Zombie zombie, ServerPlayer player) {
        ItemStack playerSkull = new ItemStack((ItemLike)Items.PLAYER_HEAD);
        playerSkull.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
        zombie.setItemSlot(EquipmentSlot.HEAD, playerSkull);
    }

    private static boolean shouldInheritHead(ServerPlayer player, EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.HEAD && player.getItemBySlot(EquipmentSlot.HEAD).isEmpty();
    }

    private static void transferInventoryAndLog(ZombieInventory zombInventory, Inventory playerInventory) {
        ForgeEvents.transferInventory(zombInventory, playerInventory);
        ForgeEvents.logTransmission(zombInventory);
    }

    private static void transferInventory(ZombieInventory zombInventory, Inventory playerInventory) {
        for (int i = 0; i < zombInventory.getSlots(); ++i) {
            zombInventory.insertItem(i, playerInventory.getItem(i), false);
            playerInventory.setItem(i, ItemStack.EMPTY);
        }
    }

    private static void logTransmission(ZombieInventory zombInventory) {
        ZombPlayer.LOGGER.debug("Player Inventory has been transferred to zombie's. Zombie Inventory: " + String.valueOf(zombInventory));
    }

    private static boolean isPlayerInfected(LivingDeathEvent event) {
        return event.getEntity() instanceof ServerPlayer && event.getSource().getEntity() instanceof Zombie;
    }

    private static Zombie spawnPersistantZombie(ServerPlayer player) {
        Zombie zombie = (Zombie)EntityType.ZOMBIE.spawn(player.serverLevel(), player.blockPosition(), MobSpawnType.CONVERSION);
        zombie.setBaby(false);
        zombie.setCustomName(player.getDisplayName());
        zombie.setCustomNameVisible(true);
        zombie.setPersistenceRequired();
        ((InfectedPlayerMark)zombie).setAsInfectedPlayer();
        return zombie;
    }
}

