/*
 * Decompiled with CFR 0.152.
 */
package com.apeng.zombplayer.event;

import com.apeng.zombplayer.ZombPlayer;
import com.apeng.zombplayer.capability.ZombieInventory;
import com.apeng.zombplayer.gamerule.ZPGameRules;
import com.apeng.zombplayer.mixinduck.InfectedPlayerMark;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.NotNull;

public class ForgeEvents {
    private static final Capability<ZombieInventory> ZOMBIE_INVENTORY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ZombieInventory>(){});
    private static ZombieInventory cachedInventory4ConvertingZombie;

    public static void cacheInvBeforeDrownedConversion(LivingConversionEvent.Pre event) {
        if (!ForgeEvents.isZombieDrowned(event) || !ForgeEvents.isZombieInfectedPlayer((LivingEvent)event)) {
            return;
        }
        Zombie zombie = (Zombie)event.getEntity();
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(zombieInventory -> {
            cachedInventory4ConvertingZombie = zombieInventory;
        });
    }

    public static void transferInvOnZombieDrownedConversion(LivingConversionEvent.Post event) {
        if (!ForgeEvents.isZombieDrowned(event) || !ForgeEvents.isZombieInfectedPlayer((LivingEvent)event)) {
            return;
        }
        Zombie zombie = (Zombie)event.getEntity();
        Drowned drowned = (Drowned)event.getOutcome();
        ((InfectedPlayerMark)drowned).setAsInfectedPlayer();
        ForgeEvents.transferInv(drowned);
    }

    private static boolean isZombieInfectedPlayer(LivingEvent event) {
        return ((InfectedPlayerMark)event.getEntity()).isInfectedPlayer();
    }

    private static void transferInv(Drowned drowned) {
        drowned.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(cachedInventory4ConvertingZombie::transferAllItemStacks);
    }

    private static boolean isZombieDrowned(LivingConversionEvent.Pre event) {
        return event.getEntity() instanceof Zombie && event.getOutcome().equals(EntityType.f_20562_);
    }

    private static boolean isZombieDrowned(LivingConversionEvent.Post event) {
        return event.getEntity() instanceof Zombie && event.getOutcome() instanceof Drowned;
    }

    public static void dropInvWhenZombieDies(LivingDropsEvent event) {
        Zombie zombie;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Zombie)) break block4;
                zombie = (Zombie)livingEntity;
                if (ForgeEvents.isZombieInfectedPlayer((LivingEvent)event)) break block5;
            }
            return;
        }
        if (ForgeEvents.isMobLootGameRuleOn(zombie)) {
            ForgeEvents.addZombieInventory2Drops(event, zombie);
        }
        ForgeEvents.invalidateInvCapability(zombie);
    }

    private static boolean isMobLootGameRuleOn(Zombie zombie) {
        return zombie.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
    }

    private static void addZombieInventory2Drops(LivingDropsEvent event, Zombie zombie) {
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(zombieInventory -> zombieInventory.forEach(itemStack -> {
            if (!itemStack.m_41619_()) {
                event.getDrops().add(new ItemEntity(zombie.m_9236_(), zombie.m_20185_(), zombie.m_20188_() - (double)0.3f, zombie.m_20189_(), itemStack));
            }
        }));
    }

    private static void invalidateInvCapability(Zombie zombie) {
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).invalidate();
    }

    public static void attachInventoryCap2Zombie(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Zombie)) {
            return;
        }
        final LazyOptional optionalStorage = LazyOptional.of(() -> new ZombieInventory(36));
        ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction direction) {
                if (cap == ZOMBIE_INVENTORY_CAPABILITY) {
                    return optionalStorage.cast();
                }
                return LazyOptional.empty();
            }

            public CompoundTag serializeNBT() {
                return ((ZombieInventory)optionalStorage.orElseThrow(() -> new NullPointerException("LazyOptional for zombie/drowned inventory is null."))).serializeNBT();
            }

            public void deserializeNBT(CompoundTag tag) {
                ((ZombieInventory)optionalStorage.orElseThrow(() -> new NullPointerException("LazyOptional for zombie/drowned inventory is null."))).deserializeNBT(tag);
            }
        };
        event.addCapability(new ResourceLocation("zombplayer", "inventory"), (ICapabilityProvider)provider);
    }

    public static void spawnZombPlayerOnInfected(LivingDeathEvent event) {
        if (!ForgeEvents.isPlayerInfected(event) || !ForgeEvents.shouldPlayerInfected(event)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Zombie zombie = ForgeEvents.spawnPersistantZombie(player);
        player.m_6842_(true);
        if (ForgeEvents.shouldKeepInventory(player)) {
            ForgeEvents.inheritHeadOnly(zombie, player);
        } else {
            ForgeEvents.transferEquipAndInv(zombie, player);
        }
    }

    private static boolean shouldPlayerInfected(LivingDeathEvent event) {
        return event.getEntity().m_9236_().m_46469_().m_46207_(ZPGameRules.RULE_DOPLAYERINFECTED);
    }

    private static void inheritHeadOnly(Zombie zombie, ServerPlayer player) {
        ForgeEvents.inheritHead(zombie, player);
        zombie.m_21409_(EquipmentSlot.HEAD, -10.0f);
    }

    private static boolean shouldKeepInventory(ServerPlayer player) {
        return player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_);
    }

    private static void transferEquipAndInv(Zombie zombie, ServerPlayer player) {
        zombie.getCapability(ZOMBIE_INVENTORY_CAPABILITY).ifPresent(zombieInventory -> {
            Inventory playerInventory = player.m_150109_();
            ForgeEvents.transferEquipments(zombie, player);
            ForgeEvents.transferInventoryAndLog(zombieInventory, playerInventory);
        });
    }

    private static void transferEquipments(Zombie zombie, ServerPlayer player) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ForgeEvents.transferEquipment(zombie, player, equipmentSlot);
            player.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
    }

    private static void transferEquipment(Zombie zombie, ServerPlayer player, EquipmentSlot equipmentSlot) {
        if (ForgeEvents.shouldInheritHead(player, equipmentSlot)) {
            ForgeEvents.inheritHeadOnly(zombie, player);
        } else {
            ForgeEvents.normalTransfer(zombie, player, equipmentSlot);
        }
    }

    private static void normalTransfer(Zombie zombie, ServerPlayer player, EquipmentSlot equipmentSlot) {
        zombie.m_8061_(equipmentSlot, player.m_6844_(equipmentSlot));
        zombie.m_21508_(equipmentSlot);
    }

    private static void inheritHead(Zombie zombie, ServerPlayer player) {
        ItemStack playerSkull = new ItemStack((ItemLike)Items.f_42680_);
        playerSkull.m_41751_(CompoundTag.builder().put("SkullOwner", player.m_5446_().getString()).build());
        zombie.m_8061_(EquipmentSlot.HEAD, playerSkull);
    }

    private static boolean shouldInheritHead(ServerPlayer player, EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.HEAD && player.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    private static void transferInventoryAndLog(ZombieInventory zombInventory, Inventory playerInventory) {
        ForgeEvents.transferInventory(zombInventory, playerInventory);
        ForgeEvents.logTransmission(zombInventory);
    }

    private static void transferInventory(ZombieInventory zombInventory, Inventory playerInventory) {
        for (int i = 0; i < zombInventory.getSlots(); ++i) {
            zombInventory.insertItem(i, playerInventory.m_8020_(i), false);
            playerInventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    private static void logTransmission(ZombieInventory zombInventory) {
        ZombPlayer.LOGGER.debug("Player Inventory has been transferred to zombie's. Zombie Inventory: " + zombInventory);
    }

    private static boolean isPlayerInfected(LivingDeathEvent event) {
        return event.getEntity() instanceof ServerPlayer && event.getSource().m_7639_() instanceof Zombie;
    }

    private static Zombie spawnPersistantZombie(ServerPlayer player) {
        Zombie zombie = (Zombie)EntityType.f_20501_.m_262496_(player.m_284548_(), player.m_20183_(), MobSpawnType.CONVERSION);
        zombie.m_6863_(false);
        zombie.m_6593_(player.m_5446_());
        zombie.m_20340_(true);
        zombie.m_21530_();
        ((InfectedPlayerMark)zombie).setAsInfectedPlayer();
        return zombie;
    }
}

