/*
 * Decompiled with CFR 0.152.
 */
package com.apeng.zombplayer.mixin;

import com.apeng.zombplayer.mixin.ZombieAT;
import com.apeng.zombplayer.mixinduck.InfectedPlayerMark;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Zombie.class})
public abstract class ZombieMixin
extends Monster
implements InfectedPlayerMark {
    @Unique
    private boolean isInfectedPlayer = false;

    protected ZombieMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Redirect(method={"dropCustomDeathLoot(Lnet/minecraft/world/damagesource/DamageSource;IZ)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/Zombie;getSkull()Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack dropPlayerSkullOnNecessary(Zombie zombie) {
        return ZombieMixin.equipPlayerSkull(zombie) ? ZombieMixin.getEquiptedSkull(zombie) : ((ZombieAT)zombie).invokeGetSkull();
    }

    @NotNull
    private static ItemStack getEquiptedSkull(Zombie zombie) {
        return zombie.m_6844_(EquipmentSlot.HEAD);
    }

    private static boolean equipPlayerSkull(Zombie zombie) {
        return ZombieMixin.getEquiptedSkull(zombie).m_150930_(Items.f_42680_);
    }

    @Override
    public boolean isInfectedPlayer() {
        return this.isInfectedPlayer;
    }

    @Override
    public void setAsInfectedPlayer() {
        this.isInfectedPlayer = true;
    }
}

