/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.lockandblock.block.custom;

import com.andersmmg.lockandblock.LockAndBlock;
import com.andersmmg.lockandblock.block.entity.KeycardReaderBlockEntity;
import com.andersmmg.lockandblock.client.screen.KeycardReaderScreen;
import com.andersmmg.lockandblock.item.ModItems;
import com.andersmmg.lockandblock.item.custom.KeycardItem;
import com.andersmmg.lockandblock.sounds.ModSounds;
import com.andersmmg.lockandblock.util.VoxelUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class KeycardReaderBlock
extends class_2237 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 VOXEL_SHAPE = class_2248.method_9541((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);

    public KeycardReaderBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected static class_2350 getDirection(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)FACING);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            return class_1269.field_5814;
        }
        if (stack.method_31574(ModItems.KEYCARD)) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof KeycardReaderBlockEntity) {
                KeycardReaderBlockEntity keycardReaderBlockEntity = (KeycardReaderBlockEntity)blockEntity;
                if (keycardReaderBlockEntity.hasUuid()) {
                    if (KeycardItem.hasUuid(stack)) {
                        if (keycardReaderBlockEntity.getUuid().equals(KeycardItem.getUuid(stack))) {
                            return this.activate(state, world, pos);
                        }
                        if (!world.field_9236) {
                            world.method_8396(null, pos, ModSounds.BEEP_ERROR, class_3419.field_15245, 1.0f, 1.0f);
                            player.method_7353((class_2561)LockAndBlock.langText("wrong_keycard"), true);
                        }
                    } else if (!world.field_9236) {
                        world.method_8396(null, pos, ModSounds.BEEP_ERROR, class_3419.field_15245, 1.0f, 1.0f);
                        player.method_7353((class_2561)LockAndBlock.langText("blank_keycard"), true);
                    }
                } else if (KeycardItem.hasUuid(stack)) {
                    if (!world.field_9236) {
                        keycardReaderBlockEntity.setUuid(KeycardItem.getUuid(stack));
                        player.method_7353((class_2561)LockAndBlock.langText("reader_programmed"), true);
                        return this.activate(state, world, pos);
                    }
                } else if (!world.field_9236) {
                    world.method_8396(null, pos, ModSounds.BEEP_ERROR, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353((class_2561)LockAndBlock.langText("blank_keycard"), true);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private class_1269 activate(class_2680 state, class_1937 world, class_2338 pos) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            if (!world.method_8608()) {
                world.method_8396(null, pos, ModSounds.BEEP_SUCCESS, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                world.method_39280(pos, (class_2248)this, 20, class_1953.field_9314);
                this.updateNeighbors(state, (class_3218)world, pos);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    private void updateNeighbors(class_2680 state, class_3218 world, class_2338 pos) {
        world.method_8452(pos, (class_2248)this);
        world.method_8452(pos.method_10093(KeycardReaderBlock.getDirection(state).method_10153()), (class_2248)this);
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false && KeycardReaderBlock.getDirection(state) == direction ? 15 : 0;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return VoxelUtils.rotateShape(KeycardReaderBlock.getDirection(state), VOXEL_SHAPE);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED});
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
            this.updateNeighbors(state, world, pos);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 side = ctx.method_8038();
        if (side == class_2350.field_11036 || side == class_2350.field_11033) {
            return null;
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)side);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KeycardReaderBlockEntity(pos, state);
    }

    public void edit(class_1838 context) {
        if (((Boolean)context.method_8045().method_8320(context.method_8037()).method_11654((class_2769)POWERED)).booleanValue()) {
            return;
        }
        if (context.method_8045().method_8608()) {
            this.showEditScreen(context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void showEditScreen(class_1838 context) {
        class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof KeycardReaderBlockEntity) {
            KeycardReaderBlockEntity keycardReaderBlockEntity = (KeycardReaderBlockEntity)blockEntity;
            class_1799 stack = context.method_8036().method_5998(context.method_20287());
            if (!keycardReaderBlockEntity.checkKeycard(stack)) {
                return;
            }
            String uuid = KeycardItem.getUuid(context.method_8036().method_5998(context.method_20287()));
            KeycardReaderScreen screen = new KeycardReaderScreen(keycardReaderBlockEntity, uuid);
            class_310.method_1551().method_1507((class_437)screen);
        }
    }
}

