/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.lockandblock.block.custom;

import com.andersmmg.lockandblock.block.entity.KeypadBlockEntity;
import com.andersmmg.lockandblock.client.screen.KeypadScreen;
import com.andersmmg.lockandblock.sounds.ModSounds;
import com.andersmmg.lockandblock.util.VoxelUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class KeypadBlock
extends class_2237 {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 SET = class_2746.method_11825((String)"set");
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 VOXEL_SHAPE = class_2248.method_9541((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);

    public KeypadBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SET, (Comparable)Boolean.valueOf(false)));
    }

    protected static class_2350 getDirection(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)FACING);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.method_8608() && !((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            this.showScreen((KeypadBlockEntity)world.method_8321(pos));
        }
        return class_1269.field_5812;
    }

    @Environment(value=EnvType.CLIENT)
    private void showScreen(KeypadBlockEntity blockEntity) {
        class_310.method_1551().method_1507((class_437)new KeypadScreen(blockEntity));
    }

    public class_1269 activate(class_2680 state, class_1937 world, class_2338 pos) {
        if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            if (!world.method_8608()) {
                world.method_8396(null, pos, ModSounds.BEEP_SUCCESS, class_3419.field_15245, 1.0f, 1.0f);
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                world.method_39280(pos, (class_2248)this, 30, class_1953.field_9314);
                this.updateNeighbors(state, (class_3218)world, pos);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_21466;
    }

    private void updateNeighbors(class_2680 state, class_3218 world, class_2338 pos) {
        world.method_8452(pos, (class_2248)this);
        world.method_8452(pos.method_10093(KeypadBlock.getDirection(state).method_10153()), (class_2248)this);
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false && KeypadBlock.getDirection(state) == direction ? 15 : 0;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return VoxelUtils.rotateShape(KeypadBlock.getDirection(state), VOXEL_SHAPE);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED, SET});
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
            this.updateNeighbors(state, world, pos);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 side = ctx.method_8038();
        if (side == class_2350.field_11036 || side == class_2350.field_11033) {
            return null;
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)side);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KeypadBlockEntity(pos, state);
    }
}

