/*
 * Decompiled with CFR 0.152.
 */
package com.andersmmg.lockandblock.block.custom;

import com.andersmmg.lockandblock.LockAndBlock;
import com.andersmmg.lockandblock.util.VoxelUtils;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5431;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class LaserSensorBlock
extends class_2248 {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 SET = LockAndBlock.SET;
    public static final class_2746 POWERED = class_2741.field_12484;
    private static final class_265 VOXEL_SHAPE = class_2248.method_9541((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)16.0);
    private static final class_265 VOXEL_SHAPE_UP = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final class_265 VOXEL_SHAPE_DOWN = class_2248.method_9541((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public LaserSensorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SET, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    private static void spawnParticles(class_2680 state, class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_2350 direction = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
        class_2350 direction2 = LaserSensorBlock.getDirection(state).method_10153();
        double d = (double)pos.method_10263() + 0.5 + 0.0 * (double)direction.method_10148() + 0.4 * (double)direction2.method_10148();
        double e = (double)pos.method_10264() + 0.5 + 0.0 * (double)direction.method_10164() + 0.4 * (double)direction2.method_10164();
        double f = (double)pos.method_10260() + 0.5 + 0.0 * (double)direction.method_10165() + 0.4 * (double)direction2.method_10165();
        float steps = 10.0f;
        for (int i = 0; i < (int)steps; ++i) {
            ((class_3218)world).method_14199((class_2394)new class_2390(class_243.method_24457((int)3194623).method_46409(), 0.5f), d + (double)direction.method_10148() * (double)((float)i / steps), e + (double)direction.method_10164() * (double)((float)i / steps), f + (double)direction.method_10165() * (double)((float)i / steps), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected static class_2350 getDirection(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)FACING);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        world.method_39280(pos, (class_2248)this, 20, class_1953.field_9314);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)SET)).booleanValue()) {
            boolean shouldPower = this.shouldPower((class_1937)world, pos, state);
            if ((Boolean)state.method_11654((class_2769)POWERED) != shouldPower) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(shouldPower)), 3);
                state.method_30101((class_1936)world, pos, 3);
            }
        } else {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SET, (Comparable)Boolean.valueOf(true)), 3);
        }
        world.method_39280(pos, (class_2248)this, 1, class_1953.method_8680((int)1));
    }

    private boolean shouldPower(class_1937 world, class_2338 pos, class_2680 state) {
        int i;
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        double distance = LockAndBlock.CONFIG.allowLaserInAir() ? (double)(LockAndBlock.CONFIG.maxLaserSensorDistance() + 1) : 0.0;
        for (i = 1; i <= LockAndBlock.CONFIG.maxLaserSensorDistance() + 1; ++i) {
            class_2680 blockState = world.method_8320(pos.method_10079(direction, i));
            String blockId = class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
            if (LockAndBlock.CONFIG.laserPassthroughWhitelist().contains(blockId) || blockState.method_26202((class_1922)world, pos.method_10079(direction, i), class_3726.method_16194()).method_1110()) continue;
            if (blockState.method_30368((class_1922)world, pos.method_10079(direction, i), direction.method_10153(), class_5431.field_25823)) {
                distance = i;
                break;
            }
            if (!blockState.method_30368((class_1922)world, pos.method_10079(direction, i), direction, class_5431.field_25823)) continue;
            distance = i + 1;
            break;
        }
        i = 1;
        while ((double)i <= distance) {
            LaserSensorBlock.spawnParticles(state, world, pos.method_10079(direction, i));
            ++i;
        }
        if (distance == 0.0) {
            return false;
        }
        double expandOffset = (distance - 1.0) / 2.0;
        class_238 detectionBox = new class_238(pos).method_1011(0.5).method_1009((double)direction.method_10148() * expandOffset, (double)direction.method_10164() * expandOffset, (double)direction.method_10165() * expandOffset).method_989((double)direction.method_10148() * (distance - 1.0) * 0.5, (double)direction.method_10164() * (distance - 1.0) * 0.5, (double)direction.method_10165() * (distance - 1.0) * 0.5);
        List entities = world.method_8390(class_1309.class, detectionBox, entity -> true);
        return !entities.isEmpty();
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)POWERED) != false ? 15 : 0;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (LaserSensorBlock.getDirection(state)) {
            case class_2350.field_11036 -> VOXEL_SHAPE_UP;
            case class_2350.field_11033 -> VOXEL_SHAPE_DOWN;
            default -> VoxelUtils.rotateShape(LaserSensorBlock.getDirection(state), VOXEL_SHAPE);
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, SET, POWERED});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8038());
    }
}

