/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5684;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ItemListComponent
extends ItemComponent {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    @Nullable
    private ImmutableList<class_1799> items;
    private float time = 0.0f;
    private List<class_5684> extraTooltipSection = List.of();
    private int currentStackIndex;

    public ItemListComponent() {
        super(class_1799.field_8037);
        this.setTooltipFromStack(true);
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.time += delta;
        if (this.time >= 20.0f) {
            this.time -= 20.0f;
            this.updateForItems();
        }
    }

    public Component tooltip(List<class_5684> tooltip) {
        if (tooltip == null) {
            return super.tooltip((List)null);
        }
        tooltip = new ArrayList<class_5684>(tooltip);
        tooltip.addAll(this.extraTooltipSection);
        this.tooltip = tooltip;
        return this;
    }

    private void updateForItems() {
        if (this.items != null && !this.items.isEmpty()) {
            this.currentStackIndex = (this.currentStackIndex + 1) % this.items.size();
            this.stack((class_1799)this.items.get(this.currentStackIndex));
        } else {
            this.currentStackIndex = 0;
            this.stack(class_1799.field_8037);
        }
    }

    public ItemListComponent ingredient(class_1856 ingredient) {
        this.items = ImmutableList.copyOf((Object[])ingredient.method_8105());
        this.updateForItems();
        return this;
    }

    public ItemListComponent tag(class_6862<class_1792> tag) {
        this.items = class_7923.field_41178.method_40266(tag).map(entries -> (ImmutableList)entries.method_40239().map(class_6880::comp_349).map(class_1792::method_7854).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
        this.updateForItems();
        return this;
    }

    public void extraTooltipSection(List<class_5684> section) {
        this.extraTooltipSection = section;
        this.updateTooltipForStack();
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"tag", tagElement -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)UIParsing.parseIdentifier((Node)tagElement)), this::tag);
        UIParsing.apply(children, (String)"ingredient", ingredientElement -> class_1856.method_52177((JsonElement)((JsonElement)GSON.fromJson(ingredientElement.getTextContent().strip(), JsonElement.class))), this::ingredient);
    }
}

