/*
 * Decompiled with CFR 0.152.
 */
package co.ata.quickquarry;

import co.ata.quickquarry.Config;
import co.ata.quickquarry.blockentities.MechanicalBreakerBlockEntity;
import co.ata.quickquarry.blockentities.QuarryBlockEntity;
import co.ata.quickquarry.blocks.MechanicalBreakerBlock;
import co.ata.quickquarry.blocks.QuarryBlock;
import co.ata.quickquarry.menu.MechanicalBreakerMenu;
import co.ata.quickquarry.menu.QuickQuarryMenu;
import co.ata.quickquarry.message.ModifyQuarrySettings;
import co.ata.quickquarry.screen.MechanicalBreakerScreen;
import co.ata.quickquarry.screen.QuickQuarryScreen;
import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="quickquarry")
public class QuickQuarry {
    public static final String MODID = "quickquarry";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"quickquarry");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"quickquarry");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"quickquarry");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"quickquarry");
    public static final RegistryObject<Block> STONE_QUARRY = BLOCKS.register("stone_quarry", () -> new QuarryBlock());
    public static final RegistryObject<Item> STONE_QUARRY_ITEM = ITEMS.register("stone_quarry", () -> new BlockItem((Block)STONE_QUARRY.get(), new Item.Properties()));
    public static final RegistryObject<Block> IRON_QUARRY = BLOCKS.register("iron_quarry", () -> new QuarryBlock().withMaxHarvestLevel(2).withMaxHeight(16).withMaxWidth(16).withMaxDepth(256));
    public static final RegistryObject<Item> IRON_QUARRY_ITEM = ITEMS.register("iron_quarry", () -> new BlockItem((Block)IRON_QUARRY.get(), new Item.Properties()));
    public static final RegistryObject<Block> ENDER_QUARRY = BLOCKS.register("ender_quarry", () -> new QuarryBlock().withMaxHarvestLevel(4).withMaxHeight(16).withMaxWidth(16).withMaxDepth(8192));
    public static final RegistryObject<Item> ENDER_QUARRY_ITEM = ITEMS.register("ender_quarry", () -> new BlockItem((Block)ENDER_QUARRY.get(), new Item.Properties()));
    public static final RegistryObject<Block> MECHANICAL_BREAKER = BLOCKS.register("mechanical_breaker", () -> new MechanicalBreakerBlock());
    public static final RegistryObject<Item> MECHANICAL_BREAKER_ITEM = ITEMS.register("mechanical_breaker", () -> new BlockItem((Block)MECHANICAL_BREAKER.get(), new Item.Properties()));
    public static final RegistryObject<BlockEntityType<QuarryBlockEntity>> QUARRY_BLOCK_ENTITY = BLOCK_ENTITIES.register("quarry_block_entity", () -> BlockEntityType.Builder.m_155273_(QuarryBlockEntity::new, (Block[])new Block[]{(Block)STONE_QUARRY.get(), (Block)IRON_QUARRY.get(), (Block)ENDER_QUARRY.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<MechanicalBreakerBlockEntity>> MECHANICAL_BREAKER_BLOCK_ENTITY = BLOCK_ENTITIES.register("mechanical_breaker_block_entity", () -> BlockEntityType.Builder.m_155273_(MechanicalBreakerBlockEntity::new, (Block[])new Block[]{(Block)MECHANICAL_BREAKER.get()}).m_58966_(null));
    public static final RegistryObject<MenuType<QuickQuarryMenu>> QUARRY_MENU = MENUS.register("quarry_menu", () -> new MenuType((MenuType.MenuSupplier)new QuickQuarryMenu.MenuFactory(), FeatureFlags.f_244332_));
    public static final RegistryObject<MenuType<MechanicalBreakerMenu>> MECHANICAL_BREAKER_MENU = MENUS.register("mechanical_breaker_menu", () -> new MenuType(MechanicalBreakerMenu::new, FeatureFlags.f_244332_));
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("quickquarry", "main"), () -> "1", "1"::equals, "1"::equals);

    public QuickQuarry() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        MENUS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        int messageNumber = 0;
        CHANNEL.registerMessage(messageNumber++, ModifyQuarrySettings.class, ModifyQuarrySettings::encode, ModifyQuarrySettings::decode, ModifyQuarrySettings::handle);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(STONE_QUARRY);
            event.accept(IRON_QUARRY);
            event.accept(ENDER_QUARRY);
            event.accept(MECHANICAL_BREAKER);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="quickquarry", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)QUARRY_MENU.get()), QuickQuarryScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)MECHANICAL_BREAKER_MENU.get()), MechanicalBreakerScreen::new);
            });
        }
    }
}

