/*
 * Decompiled with CFR 0.152.
 */
package co.ata.quickquarry.blockentities;

import co.ata.quickquarry.QuickQuarry;
import co.ata.quickquarry.blocks.MechanicalBreakerBlock;
import co.ata.quickquarry.interfaces.WorldlyContainerWrapper;
import co.ata.quickquarry.menu.MechanicalBreakerMenu;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class MechanicalBreakerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    ItemStack toolSlot = ItemStack.f_41583_;
    public static int lastBreakID = -557785427;
    public int breakID = lastBreakID++;
    FakePlayer fakePlayer = null;
    static GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.fromString("2892b99e-2caf-4ff4-93b1-bde471c87fa7"), "Mechanical Breaker");
    @Nullable
    private Component name;
    float breakProgress = 0.0f;
    float stabProgress = 0.0f;

    public MechanicalBreakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)QuickQuarry.MECHANICAL_BREAKER_BLOCK_ENTITY.get(), pos, state);
    }

    public AbstractContainerMenu m_7208_(int containerID, Inventory playerInventory, Player player) {
        return new MechanicalBreakerMenu(containerID, playerInventory, this);
    }

    public Component m_7755_() {
        return this.name;
    }

    public Component m_6820_() {
        return this.f_58857_.m_8055_(this.f_58858_).m_60734_().m_49954_();
    }

    public Component m_5446_() {
        return this.name != null ? this.name : this.m_6820_();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity instanceof MechanicalBreakerBlockEntity) {
            ((MechanicalBreakerBlockEntity)blockEntity).tick();
        }
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)MechanicalBreakerBlock.FACING);
    }

    public void tick() {
        int i;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.f_58857_), (GameProfile)FAKE_PLAYER_PROFILE);
        }
        BlockPos targetPos = this.f_58858_.m_121955_(this.getFacing().m_122436_());
        BlockState targetBlock = this.f_58857_.m_8055_(targetPos);
        this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, this.toolSlot);
        if (targetBlock.m_60795_()) {
            this.f_58857_.m_6801_(this.breakID, targetPos, -1);
            this.breakProgress = 0.0f;
            if (this.toolSlot.m_204131_().toList().contains(ItemTags.f_271388_)) {
                this.stabProgress += 1.0f;
                if (this.stabProgress >= this.fakePlayer.m_36333_()) {
                    this.stabProgress = 0.0f;
                    List victims = this.f_58857_.m_6249_((Entity)null, new AABB(targetPos), e -> e instanceof LivingEntity);
                    Field attackStrengthTicker = null;
                    try {
                        attackStrengthTicker = LivingEntity.class.getDeclaredField("attackStrengthTicker");
                        attackStrengthTicker.setAccessible(true);
                    }
                    catch (NoSuchFieldException e2) {
                        e2.printStackTrace();
                    }
                    Multimap weaponAttributes = this.toolSlot.m_41638_(EquipmentSlot.MAINHAND);
                    this.fakePlayer.m_21204_().m_22178_(weaponAttributes);
                    for (Entity victim : victims) {
                        try {
                            attackStrengthTicker.set(this.fakePlayer, 1000);
                        }
                        catch (IllegalAccessException | NullPointerException e3) {
                            e3.printStackTrace();
                        }
                        this.fakePlayer.m_5706_(victim);
                    }
                    this.toolSlot = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND);
                    this.fakePlayer.m_21204_().m_22161_(weaponAttributes);
                }
            } else {
                this.stabProgress = 0.0f;
            }
            return;
        }
        float f = targetBlock.m_60800_((BlockGetter)this.f_58857_, targetPos);
        if (f <= 0.0f) {
            this.f_58857_.m_6801_(this.breakID, targetPos, -1);
            this.breakProgress = 0.0f;
            return;
        }
        int n = i = ForgeHooks.isCorrectToolForDrops((BlockState)targetBlock, (Player)this.fakePlayer) ? 30 : 100;
        if (targetBlock.m_60834_() && i == 100) {
            this.f_58857_.m_6801_(this.breakID, targetPos, -1);
            this.breakProgress = 0.0f;
            return;
        }
        float speed = this.fakePlayer.getDigSpeed(targetBlock, targetPos) / f / (float)i;
        if (speed <= 0.0f) {
            this.f_58857_.m_6801_(this.breakID, targetPos, -1);
            this.breakProgress = 0.0f;
            return;
        }
        this.breakProgress += speed * 5.0f;
        if (this.breakProgress >= 1.0f) {
            this.breakProgress = 0.0f;
            this.f_58857_.m_6801_(this.breakID, targetPos, -1);
            LootParams.Builder lootparams = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)targetPos)).m_287286_(LootContextParams.f_81461_, (Object)targetBlock).m_287289_(LootContextParams.f_81462_, (Object)this.f_58857_.m_7702_(targetPos)).m_287289_(LootContextParams.f_81455_, (Object)this.fakePlayer).m_287289_(LootContextParams.f_81463_, (Object)this.toolSlot);
            ArrayList<ItemStack> drops = targetBlock.m_287290_(lootparams);
            this.f_58857_.m_46953_(targetPos, false, (Entity)this.fakePlayer);
            this.toolSlot.m_41622_(1, (LivingEntity)this.fakePlayer, player -> player.m_21190_(InteractionHand.MAIN_HAND));
            this.toolSlot = this.fakePlayer.m_21120_(InteractionHand.MAIN_HAND);
            Object targetContainer = this.f_58857_.m_7702_(this.f_58858_.m_121955_(this.getFacing().m_122424_().m_122436_()));
            if (targetContainer instanceof Container && !(targetContainer instanceof WorldlyContainer)) {
                targetContainer = new WorldlyContainerWrapper((Container)targetContainer);
            }
            if (targetContainer instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)targetContainer;
                ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
                for (ItemStack drop : drops) {
                    int[] slotsAccessable;
                    if (drop.m_41619_()) continue;
                    for (int slot : slotsAccessable = container.m_7071_(this.getFacing())) {
                        if (!container.m_7155_(slot, drop, this.getFacing())) continue;
                        ItemStack stack = container.m_8020_(slot);
                        if (stack.m_41619_()) {
                            container.m_6836_(slot, drop);
                            drop = ItemStack.f_41583_;
                            break;
                        }
                        if (stack.m_41613_() >= stack.m_41741_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)drop)) continue;
                        int count = Math.min(stack.m_41741_() - stack.m_41613_(), drop.m_41613_());
                        stack.m_41769_(count);
                        drop.m_41774_(count);
                        if (drop.m_41619_()) break;
                    }
                    if (drop.m_41619_()) continue;
                    remaining.add(drop);
                }
                drops = remaining;
            }
            for (ItemStack drop : drops) {
                if (drop.m_41619_()) continue;
                Containers.m_18992_((Level)this.f_58857_, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), (ItemStack)drop);
            }
        } else {
            this.f_58857_.m_6801_(this.breakID, targetPos, (int)(this.breakProgress * 10.0f));
        }
    }

    public void m_6211_() {
        this.toolSlot = ItemStack.f_41583_;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.toolSlot.m_41619_();
    }

    public ItemStack m_8020_(int slotIndex) {
        return slotIndex == 0 ? this.toolSlot : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int count) {
        if (slot != 0) {
            return ItemStack.f_41583_;
        }
        return this.toolSlot.m_41620_(count);
    }

    public ItemStack m_8016_(int p_18951_) {
        if (p_18951_ != 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = this.toolSlot;
        this.toolSlot = ItemStack.f_41583_;
        return itemstack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot == 0) {
            this.toolSlot = stack;
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new MechanicalBreakerMenu(containerId, inventory, this);
    }

    public int[] m_7071_(Direction face) {
        if (face.m_122434_() == this.getFacing().m_122434_()) {
            return new int[0];
        }
        return new int[]{0};
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction face) {
        if (slot != 0) {
            return false;
        }
        if (face.m_122434_() == this.getFacing().m_122434_()) {
            return false;
        }
        return MechanicalBreakerMenu.IsTool(stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction face) {
        if (slot != 0) {
            return false;
        }
        return face.m_122434_() != this.getFacing().m_122434_();
    }

    public void m_183515_(CompoundTag compound) {
        NonNullList buffer = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        buffer.set(0, (Object)this.toolSlot);
        ContainerHelper.m_18973_((CompoundTag)compound, (NonNullList)buffer);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        NonNullList buffer = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, (NonNullList)buffer);
        this.toolSlot = (ItemStack)buffer.get(0);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void destroyed() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockPos targetPos = this.f_58858_.m_121955_(this.getFacing().m_122436_());
            this.f_58857_.m_6801_(this.breakID, targetPos, -1);
            if (!this.toolSlot.m_41619_()) {
                NonNullList buffer = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
                buffer.set(0, (Object)this.toolSlot);
                Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, (NonNullList)buffer);
            }
        }
    }
}

