/*
 * Decompiled with CFR 0.152.
 */
package co.ata.quickquarry.blockentities;

import co.ata.quickquarry.QuickQuarry;
import co.ata.quickquarry.blocks.QuarryBlock;
import co.ata.quickquarry.menu.QuickQuarryMenu;
import co.ata.quickquarry.message.ModifyQuarrySettings;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class QuarryBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    @Nullable
    private Component name;
    public int height = 1;
    public int width = 1;
    public int depth = 1;
    public boolean pointedForwards = false;
    public boolean isRoundRobin = false;
    public boolean enabled = false;
    public int scanIndex = 0;

    public QuarryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)QuickQuarry.QUARRY_BLOCK_ENTITY.get(), pos, state);
        this.depth = ((QuarryBlock)state.m_60734_()).maxDepth;
        this.height = ((QuarryBlock)state.m_60734_()).maxHeight;
        this.width = ((QuarryBlock)state.m_60734_()).maxWidth;
    }

    public AbstractContainerMenu m_7208_(int containerID, Inventory playerInventory, Player player) {
        return new QuickQuarryMenu(containerID, playerInventory, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this);
    }

    public Component m_7755_() {
        return this.name;
    }

    public Component getDefaultName() {
        return this.f_58857_.m_8055_(this.f_58858_).m_60734_().m_49954_();
    }

    public Component m_5446_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof QuarryBlockEntity) {
            ((QuarryBlockEntity)blockEntity).tick();
        }
    }

    private BlockPos posFromIndex() {
        int right = this.scanIndex % this.width;
        int up = this.scanIndex / this.width % this.height;
        int deep = this.scanIndex / (this.width * this.height);
        Vec3i rightDirection = ((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)).m_122428_().m_122436_();
        Vec3i upDirection = this.pointedForwards ? new Vec3i(0, 1, 0) : ((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)).m_122424_().m_122436_();
        Vec3i deepDirection = this.pointedForwards ? ((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)).m_122424_().m_122436_() : new Vec3i(0, -1, 0);
        BlockPos origin = this.f_58858_;
        origin = this.pointedForwards ? origin.m_121955_(((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)).m_122424_().m_122436_()) : origin.m_121955_(new Vec3i(0, -1, 0));
        return origin.m_121955_(rightDirection.m_142393_(right)).m_121955_(upDirection.m_142393_(up)).m_121955_(deepDirection.m_142393_(deep));
    }

    private boolean blockHasTag(BlockState block, TagKey<Block> tag) {
        return block.m_204343_().toList().contains(tag);
    }

    private int blockHarvestLevel(BlockState block) {
        if (!block.m_60834_()) {
            return 0;
        }
        if (!this.blockHasTag(block, (TagKey<Block>)BlockTags.f_144282_)) {
            return 5;
        }
        if (this.blockHasTag(block, (TagKey<Block>)BlockTags.f_144286_)) {
            return 1;
        }
        if (this.blockHasTag(block, (TagKey<Block>)BlockTags.f_144285_)) {
            return 2;
        }
        if (this.blockHasTag(block, (TagKey<Block>)BlockTags.f_144284_)) {
            return 3;
        }
        return 0;
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        if (!this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_247087_()) {
            return;
        }
        int maxVoidScan = this.width * this.height * 16;
        QuarryBlock quarryBlock = (QuarryBlock)this.m_58900_().m_60734_();
        for (int i = 0; i < maxVoidScan; ++i) {
            BlockPos scanPos;
            if (this.scanIndex >= this.width * this.height * this.depth) {
                this.scanIndex = 0;
            }
            if (this.f_58857_.m_46859_(scanPos = this.posFromIndex())) {
                ++this.scanIndex;
                continue;
            }
            BlockState block = this.f_58857_.m_8055_(scanPos);
            if (block.m_247087_() || !block.m_60819_().m_76178_()) {
                ++this.scanIndex;
                continue;
            }
            if (this.blockHarvestLevel(block) > quarryBlock.maxHarvestLevel) {
                ++this.scanIndex;
                continue;
            }
            if (this.f_58857_.m_7702_(scanPos) != null) {
                ++this.scanIndex;
                continue;
            }
            this.f_58857_.m_46597_(this.f_58858_.m_7494_(), block);
            this.f_58857_.m_46597_(scanPos, Blocks.f_50016_.m_49966_());
            this.scanIndex = this.isRoundRobin ? ++this.scanIndex : 0;
            return;
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128405_("Height", this.height);
        tag.m_128405_("Width", this.width);
        tag.m_128405_("Depth", this.depth);
        tag.m_128379_("PointedForwards", this.pointedForwards);
        tag.m_128379_("IsRoundRobin", this.isRoundRobin);
        tag.m_128405_("ScanIndex", this.scanIndex);
        tag.m_128379_("Enabled", this.enabled);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.height = tag.m_128451_("Height");
        this.width = tag.m_128451_("Width");
        this.depth = tag.m_128451_("Depth");
        this.pointedForwards = tag.m_128471_("PointedForwards");
        this.isRoundRobin = tag.m_128471_("IsRoundRobin");
        this.scanIndex = tag.m_128451_("ScanIndex");
        this.enabled = tag.m_128471_("Enabled");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        tag.m_128405_("Height", this.height);
        tag.m_128405_("Width", this.width);
        tag.m_128405_("Depth", this.depth);
        tag.m_128379_("PointedForwards", this.pointedForwards);
        tag.m_128379_("IsRoundRobin", this.isRoundRobin);
        tag.m_128405_("ScanIndex", this.scanIndex);
        tag.m_128379_("Enabled", this.enabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.height = tag.m_128451_("Height");
        this.width = tag.m_128451_("Width");
        this.depth = tag.m_128451_("Depth");
        this.pointedForwards = tag.m_128471_("PointedForwards");
        this.isRoundRobin = tag.m_128471_("IsRoundRobin");
        this.scanIndex = tag.m_128451_("ScanIndex");
        this.enabled = tag.m_128471_("Enabled");
    }

    public void sendSetSettingsPacket(ModifyQuarrySettings.Setting setting, int value) {
        ModifyQuarrySettings msg = new ModifyQuarrySettings();
        msg.setting = setting;
        msg.value = value;
        msg.pos = this.f_58858_;
        QuickQuarry.CHANNEL.sendToServer((Object)msg);
    }

    public void setSetting(ModifyQuarrySettings.Setting setting, int value) {
        QuarryBlock block = (QuarryBlock)this.m_58900_().m_60734_();
        switch (setting) {
            case HEIGHT: {
                this.height = value;
                if (this.height < 1) {
                    this.height = block.maxHeight;
                }
                if (this.height <= block.maxHeight) break;
                this.height = 1;
                break;
            }
            case WIDTH: {
                this.width = value;
                if (this.width < 1) {
                    this.width = block.maxWidth;
                }
                if (this.width <= block.maxWidth) break;
                this.width = 1;
                break;
            }
            case DEPTH: {
                this.depth = value;
                if (this.depth < 1) {
                    this.depth = block.maxDepth;
                }
                if (this.depth <= block.maxDepth) break;
                this.depth = 1;
                break;
            }
            case POINTED_FORWARDS: {
                this.pointedForwards = value != 0;
                break;
            }
            case IS_ROUND_ROBIN: {
                this.isRoundRobin = value != 0;
                break;
            }
            case ENABLED: {
                this.enabled = value != 0;
            }
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        this.scanIndex = 0;
        this.m_6596_();
    }
}

