/*
 * Decompiled with CFR 0.152.
 */
package co.ata.quickquarry.message;

import co.ata.quickquarry.blockentities.QuarryBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ModifyQuarrySettings {
    public int value = 0;
    public Setting setting = Setting.HEIGHT;
    public BlockPos pos;

    public static void handle(ModifyQuarrySettings msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                return;
            }
            BlockEntity tile = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_7702_(msg.pos);
            if (tile instanceof QuarryBlockEntity) {
                QuarryBlockEntity quarry = (QuarryBlockEntity)tile;
                quarry.setSetting(msg.setting, msg.value);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(ModifyQuarrySettings msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.setting.ordinal());
        buf.writeInt(msg.value);
        buf.m_130064_(msg.pos);
    }

    public static ModifyQuarrySettings decode(FriendlyByteBuf buf) {
        ModifyQuarrySettings set = new ModifyQuarrySettings();
        set.setting = Setting.values()[buf.readInt()];
        set.value = buf.readInt();
        set.pos = buf.m_130135_();
        return set;
    }

    public static enum Setting {
        HEIGHT,
        WIDTH,
        DEPTH,
        POINTED_FORWARDS,
        IS_ROUND_ROBIN,
        ENABLED;

    }
}

