/*
 * Decompiled with CFR 0.152.
 */
package co.ata.quickquarry.screen;

import co.ata.quickquarry.blockentities.QuarryBlockEntity;
import co.ata.quickquarry.blocks.QuarryBlock;
import co.ata.quickquarry.menu.QuickQuarryMenu;
import co.ata.quickquarry.message.ModifyQuarrySettings;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class QuickQuarryScreen
extends AbstractContainerScreen<QuickQuarryMenu> {
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("quickquarry", "textures/gui/container/quarry.png");
    protected EditBox Height;
    protected EditBox Width;
    protected EditBox Depth;
    protected Button IsForward;
    protected Button IsDown;
    protected Button RoundRobin;
    protected Button Scanning;
    protected Button OnButton;
    protected Button OffButton;
    private boolean avoidRecurse = false;

    public QuickQuarryScreen(QuickQuarryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.m_232761_();
    }

    public QuarryBlockEntity getTile() {
        return ((QuickQuarryMenu)this.f_97732_).tile;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.avoidRecurse) {
            return;
        }
        this.avoidRecurse = true;
        this.m_232761_();
        this.avoidRecurse = false;
    }

    public void HeightResponder(String text) {
        this.Height.m_94202_(0xFFFFFF);
        if (text.matches("\\D")) {
            this.Height.m_94202_(0xFF0000);
            return;
        }
        try {
            int value = Integer.parseInt(text);
            if (value < 1 || value > ((QuarryBlock)this.getTile().m_58900_().m_60734_()).maxHeight) {
                this.Height.m_94202_(0xFF0000);
                return;
            }
            this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.HEIGHT, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void WidthResponder(String text) {
        this.Width.m_94202_(0xFFFFFF);
        if (text.matches("\\D")) {
            this.Width.m_94202_(0xFF0000);
            return;
        }
        try {
            int value = Integer.parseInt(text);
            if (value < 1 || value > ((QuarryBlock)this.getTile().m_58900_().m_60734_()).maxWidth) {
                this.Width.m_94202_(0xFF0000);
                return;
            }
            this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.WIDTH, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void DepthResponder(String text) {
        this.Depth.m_94202_(0xFFFFFF);
        if (text.matches("\\D")) {
            this.Depth.m_94202_(0xFF0000);
            return;
        }
        try {
            int value = Integer.parseInt(text);
            if (value < 1 || value > ((QuarryBlock)this.getTile().m_58900_().m_60734_()).maxDepth) {
                this.Depth.m_94202_(0xFF0000);
                return;
            }
            this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.DEPTH, value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void m_232761_() {
        super.m_232761_();
        int i = this.f_97735_;
        int j = this.f_97736_;
        QuarryBlockEntity tile = this.getTile();
        this.Height = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, i + 10, j + 30, 50, 20, (Component)Component.m_237119_()));
        this.Width = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, i + 10, j + 70, 50, 20, (Component)Component.m_237119_()));
        this.Depth = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, i + 10, j + 110, 50, 20, (Component)Component.m_237119_()));
        this.Height.m_94144_("" + tile.height);
        this.Width.m_94144_("" + tile.width);
        this.Depth.m_94144_("" + tile.depth);
        this.Height.m_94151_(this::HeightResponder);
        this.Width.m_94151_(this::WidthResponder);
        this.Depth.m_94151_(this::DepthResponder);
        this.IsForward = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Forward"), this::ToggleForward).m_252794_(i + 80, j + 45).m_253046_(80, 20).m_253136_());
        this.IsDown = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Down"), this::ToggleDown).m_252794_(i + 80, j + 20).m_253046_(80, 20).m_253136_());
        this.IsForward.f_93623_ = !this.getTile().pointedForwards;
        this.IsDown.f_93623_ = this.getTile().pointedForwards;
        this.RoundRobin = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Round Robin"), this::ToggleRoundRobin).m_252794_(i + 80, j + 105).m_253046_(80, 20).m_253136_());
        this.Scanning = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Scanning"), this::ToggleScanning).m_252794_(i + 80, j + 80).m_253046_(80, 20).m_253136_());
        this.RoundRobin.f_93623_ = !this.getTile().isRoundRobin;
        this.Scanning.f_93623_ = this.getTile().isRoundRobin;
        this.OnButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"On"), this::ToggleOn).m_252794_(i + 120, j + 135).m_253046_(30, 20).m_253136_());
        this.OffButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"Off"), this::ToggleOff).m_252794_(i + 85, j + 135).m_253046_(30, 20).m_253136_());
        this.OnButton.f_93623_ = !this.getTile().enabled;
        this.OffButton.f_93623_ = this.getTile().enabled;
    }

    protected void DecreaseHeight(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.HEIGHT, this.getTile().height - 1);
        this.m_232761_();
    }

    protected void IncreaseHeight(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.HEIGHT, this.getTile().height + 1);
        this.m_232761_();
    }

    protected void DecreaseWidth(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.WIDTH, this.getTile().width - 1);
        this.m_232761_();
    }

    protected void IncreaseWidth(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.WIDTH, this.getTile().width + 1);
        this.m_232761_();
    }

    protected void DecreaseDepth(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.DEPTH, this.getTile().depth - 1);
        this.m_232761_();
    }

    protected void IncreaseDepth(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.DEPTH, this.getTile().depth + 1);
        this.m_232761_();
    }

    protected void ToggleForward(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.POINTED_FORWARDS, 1);
        this.getTile().pointedForwards = true;
        this.m_232761_();
    }

    protected void ToggleDown(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.POINTED_FORWARDS, 0);
        this.getTile().pointedForwards = false;
        this.m_232761_();
    }

    protected void ToggleRoundRobin(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.IS_ROUND_ROBIN, 1);
        this.getTile().isRoundRobin = true;
        this.m_232761_();
    }

    protected void ToggleScanning(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.IS_ROUND_ROBIN, 0);
        this.getTile().isRoundRobin = false;
        this.m_232761_();
    }

    protected void ToggleOn(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.ENABLED, 1);
        this.getTile().enabled = true;
        this.m_232761_();
    }

    protected void ToggleOff(Button button) {
        this.getTile().sendSetSettingsPacket(ModifyQuarrySettings.Setting.ENABLED, 0);
        this.getTile().enabled = false;
        this.m_232761_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.m_7286_(graphics, partialTicks, mouseX, mouseY);
        this.m_280072_(graphics, mouseX, mouseY);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        graphics.m_280218_(BG_TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)i, (double)j, 0.0);
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280056_(this.f_96547_, "Height", 10, 20, 0x404040, false);
        graphics.m_280056_(this.f_96547_, "Width", 10, 60, 0x404040, false);
        graphics.m_280056_(this.f_96547_, "Depth", 10, 100, 0x404040, false);
        graphics.m_280168_().m_85849_();
    }
}

