/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.svoisc.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.svoisc.world.features.BatutikFeature;
import net.mcreator.svoisc.world.features.ElectoFeature;
import net.mcreator.svoisc.world.features.KaruseFeature;
import net.mcreator.svoisc.world.features.Kisel9Feature;
import net.mcreator.svoisc.world.features.KiselaFeature;
import net.mcreator.svoisc.world.features.ParrFeature;
import net.mcreator.svoisc.world.features.Rad9Feature;
import net.mcreator.svoisc.world.features.RadiFeature;
import net.mcreator.svoisc.world.features.VoronaFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class SvoiscModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"svoisc");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> BATUTIK = SvoiscModFeatures.register("batutik", BatutikFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, BatutikFeature.GENERATE_BIOMES, BatutikFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RADI = SvoiscModFeatures.register("radi", RadiFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, RadiFeature.GENERATE_BIOMES, RadiFeature::placedFeature));
    public static final RegistryObject<Feature<?>> VORONA = SvoiscModFeatures.register("vorona", VoronaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, VoronaFeature.GENERATE_BIOMES, VoronaFeature::placedFeature));
    public static final RegistryObject<Feature<?>> KARUSE = SvoiscModFeatures.register("karuse", KaruseFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, KaruseFeature.GENERATE_BIOMES, KaruseFeature::placedFeature));
    public static final RegistryObject<Feature<?>> PARR = SvoiscModFeatures.register("parr", ParrFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, ParrFeature.GENERATE_BIOMES, ParrFeature::placedFeature));
    public static final RegistryObject<Feature<?>> KISELA = SvoiscModFeatures.register("kisela", KiselaFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, KiselaFeature.GENERATE_BIOMES, KiselaFeature::placedFeature));
    public static final RegistryObject<Feature<?>> KISEL_9 = SvoiscModFeatures.register("kisel_9", Kisel9Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Kisel9Feature.GENERATE_BIOMES, Kisel9Feature::placedFeature));
    public static final RegistryObject<Feature<?>> RAD_9 = SvoiscModFeatures.register("rad_9", Rad9Feature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, Rad9Feature.GENERATE_BIOMES, Rad9Feature::placedFeature));
    public static final RegistryObject<Feature<?>> ELECTO = SvoiscModFeatures.register("electo", ElectoFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, ElectoFeature.GENERATE_BIOMES, ElectoFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

