/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.capability.timed_enchantment;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.andrew_coursin.magical_staffs.event.TimedEnchantmentEndEvent;
import net.andrew_coursin.magical_staffs.level.TimedEnchantmentSavedData;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="magical_staffs")
public class TimedEnchantment {
    private int duration;
    private final Enchantment enchantment;
    private final int id;
    private final int level;
    private static int MAX_ID = 0;
    public static final TimedEnchantmentSavedData TIMED_ENCHANTMENT_SAVED_DATA = new TimedEnchantmentSavedData();

    public TimedEnchantment(boolean addToSavedData, CompoundTag compoundTag) {
        this.duration = compoundTag.m_128451_("duration");
        this.enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)compoundTag.m_128461_("enchantment")));
        this.level = compoundTag.m_128451_("lvl");
        this.id = compoundTag.m_128451_("id");
        if (this.id > MAX_ID) {
            MAX_ID = this.id;
        }
        if (addToSavedData) {
            TIMED_ENCHANTMENT_SAVED_DATA.add(this);
        }
    }

    public TimedEnchantment(Enchantment pEnchantment, int pDuration, int pLevel) {
        this.duration = pDuration;
        this.enchantment = pEnchantment;
        this.level = pLevel;
        this.id = ++MAX_ID;
        TIMED_ENCHANTMENT_SAVED_DATA.add(this);
    }

    public boolean tick(List<ServerPlayer> players) {
        if (this.duration > 0) {
            --this.duration;
            return false;
        }
        MinecraftForge.EVENT_BUS.post((Event)new TimedEnchantmentEndEvent(this.id));
        for (ServerPlayer player : players) {
            player.f_36096_.m_182423_();
        }
        return true;
    }

    public CompoundTag save() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("duration", this.duration);
        compoundTag.m_128359_("enchantment", String.valueOf(EnchantmentHelper.m_182432_((Enchantment)this.enchantment)));
        compoundTag.m_128405_("lvl", this.level);
        compoundTag.m_128405_("id", this.id);
        return compoundTag;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public static TimedEnchantmentSavedData createSavedData() {
        return TIMED_ENCHANTMENT_SAVED_DATA;
    }

    public static TimedEnchantmentSavedData loadSavedData(CompoundTag compoundTag) {
        return TIMED_ENCHANTMENT_SAVED_DATA.load(compoundTag);
    }
}

