/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.capability.timed_enchantment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantment;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantmentsCapabilityInterface;
import net.andrew_coursin.magical_staffs.event.TimedEnchantmentEndEvent;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TimedEnchantmentsCapabilityImplementation
implements TimedEnchantmentsCapabilityInterface {
    private final ArrayList<TimedEnchantment> timedEnchantments;
    private final ItemStack itemStack;
    private final Map<Integer, Integer> displayDurations = new HashMap<Integer, Integer>();
    private static final String KEY = "TimedEnchantments";

    public TimedEnchantmentsCapabilityImplementation(ArrayList<TimedEnchantment> pTimedEnchantments, ItemStack pItemStack) {
        this.itemStack = pItemStack;
        this.timedEnchantments = pTimedEnchantments;
    }

    @Override
    public ArrayList<TimedEnchantment> getTimedEnchantments() {
        return this.timedEnchantments;
    }

    @Override
    public CompoundTag serializeDurations() {
        CompoundTag compoundTag = new CompoundTag();
        this.timedEnchantments.forEach(timedEnchantment -> compoundTag.m_128405_(String.valueOf(timedEnchantment.getId()), timedEnchantment.getDuration()));
        return compoundTag;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (TimedEnchantment timedEnchantment : this.timedEnchantments) {
            listTag.add((Object)timedEnchantment.save());
        }
        compoundTag.m_128365_(KEY, (Tag)listTag);
        return compoundTag;
    }

    @Override
    public int getDisplayDuration(int id) {
        return this.displayDurations.getOrDefault(id, 0);
    }

    @Override
    public void addTimedEnchantment(TimedEnchantment timedEnchantment) {
        this.timedEnchantments.add(timedEnchantment);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void deserializeDurations(CompoundTag compoundTag) {
        this.displayDurations.clear();
        compoundTag.m_128431_().forEach(key -> this.displayDurations.put(Integer.valueOf(key), compoundTag.m_128451_(key)));
    }

    public void deserializeNBT(CompoundTag pNbt) {
        this.timedEnchantments.clear();
        for (Tag tag : pNbt.m_128437_(KEY, 10)) {
            CompoundTag compoundTag = (CompoundTag)tag;
            TimedEnchantment timedEnchantment = TimedEnchantment.TIMED_ENCHANTMENT_SAVED_DATA.get(compoundTag.m_128451_("id"));
            if (timedEnchantment == null) {
                this.timedEnchantmentEnd(new TimedEnchantment(false, compoundTag));
                continue;
            }
            this.addTimedEnchantment(timedEnchantment);
        }
    }

    @Override
    public void removeTimedEnchantment(int id) {
        for (TimedEnchantment timedEnchantment : this.timedEnchantments) {
            if (timedEnchantment.getId() != id) continue;
            this.timedEnchantments.remove(timedEnchantment);
            this.timedEnchantmentEnd(timedEnchantment);
            break;
        }
    }

    @Override
    public void timedEnchantmentEnd(TimedEnchantment timedEnchantment) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)this.itemStack);
        int newLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)timedEnchantment.getEnchantment(), (ItemStack)this.itemStack) - timedEnchantment.getLevel();
        if (newLevel <= 0) {
            enchantments.remove(timedEnchantment.getEnchantment());
        } else {
            enchantments.put(timedEnchantment.getEnchantment(), newLevel);
        }
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)this.itemStack);
        if (this.timedEnchantments.isEmpty()) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent
    public void timedEnchantmentEnd(TimedEnchantmentEndEvent event) {
        this.removeTimedEnchantment(event.getId());
    }
}

