/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.andrew_coursin.magical_staffs.item.custom.StaffItem;
import net.andrew_coursin.magical_staffs.item.forge_material.ForgeMaterial;
import net.andrew_coursin.magical_staffs.item.forge_material.ForgeMaterials;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SmithingForgeRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;

    public SmithingForgeRecipe(ResourceLocation pId, Ingredient pTemplate, Ingredient pBase, Ingredient pAddition) {
        this.id = pId;
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
    }

    public static void register() {
        ForgeRegistries.RECIPE_SERIALIZERS.register(new ResourceLocation("magical_staffs", "smithing_forge"), (Object)new Serializer());
    }

    public boolean m_266253_(ItemStack pStack) {
        return this.addition.test(pStack);
    }

    public boolean m_266343_(ItemStack pStack) {
        return this.base.test(pStack);
    }

    public boolean m_142505_() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(ForgeHooks::hasNoElements);
    }

    public boolean m_266166_(ItemStack pStack) {
        return this.template.test(pStack);
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.template.test(pContainer.m_8020_(0)) && this.base.test(pContainer.m_8020_(1)) && this.addition.test(pContainer.m_8020_(2));
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        StaffItem staffItem;
        ItemStack resultItemStack;
        Item item;
        ItemStack materialItemStack;
        ItemStack baseItemStack = pContainer.m_8020_(1);
        if (this.base.test(baseItemStack) && this.addition.test(materialItemStack = pContainer.m_8020_(2)) && (item = (resultItemStack = baseItemStack.m_41777_()).m_41720_()) instanceof StaffItem && (staffItem = (StaffItem)item).canForge(resultItemStack)) {
            ForgeMaterial forgeMaterial = ForgeMaterials.getForgeMaterialFromIngredient(materialItemStack);
            resultItemStack.m_41714_((Component)Component.m_237110_((String)"forge_material.magical_staffs.hover_name", (Object[])new Object[]{Component.m_237115_((String)Util.m_137492_((String)"forge_material", (ResourceLocation)new ResourceLocation("magical_staffs", forgeMaterial.name()))), Component.m_237115_((String)resultItemStack.m_41778_())}).m_130948_(forgeMaterial.style()));
            resultItemStack.m_41784_().m_128359_(ForgeMaterials.KEY, forgeMaterial.name());
            return resultItemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)Items.f_42393_);
    }

    public RecipeSerializer<?> m_7707_() {
        return Objects.requireNonNull((RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("magical_staffs", "smithing_forge")));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer
    implements RecipeSerializer<SmithingForgeRecipe> {
        public SmithingForgeRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"addition"));
            return new SmithingForgeRecipe(resourceLocation, ingredient, ingredient1, ingredient2);
        }

        public SmithingForgeRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            return new SmithingForgeRecipe(resourceLocation, ingredient, ingredient1, ingredient2);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SmithingForgeRecipe pRecipe) {
            pRecipe.template.m_43923_(pBuffer);
            pRecipe.base.m_43923_(pBuffer);
            pRecipe.addition.m_43923_(pBuffer);
        }
    }
}

