/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.event;

import javax.annotation.ParametersAreNonnullByDefault;
import net.andrew_coursin.magical_staffs.capability.attack_effects.AttackEffectsCapabilityInterface;
import net.andrew_coursin.magical_staffs.capability.attack_effects.AttackEffectsCapabilityProvider;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantment;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantmentsCapabilityInterface;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantmentsCapabilityProvider;
import net.andrew_coursin.magical_staffs.capability.timer.TimerCapabilityInterface;
import net.andrew_coursin.magical_staffs.capability.timer.TimerCapabilityProvider;
import net.andrew_coursin.magical_staffs.effect.AttackMobEffect;
import net.andrew_coursin.magical_staffs.inventory.StaffItemListener;
import net.andrew_coursin.magical_staffs.item.custom.StaffItem;
import net.andrew_coursin.magical_staffs.networking.ModPacketHandler;
import net.andrew_coursin.magical_staffs.networking.packet.AddTimedEnchantmentsTooltipsC2SPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="magical_staffs")
@ParametersAreNonnullByDefault
public class ModEvents {
    @SubscribeEvent
    public static void addAttackEffect(MobEffectEvent.Added event) {
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        if (mobEffect instanceof AttackMobEffect) {
            AttackMobEffect attackMobEffect = (AttackMobEffect)mobEffect;
            event.getEntity().getCapability(AttackEffectsCapabilityProvider.ATTACK_EFFECTS).ifPresent(attackEffects -> {
                int duration = event.getEffectInstance().m_267577_() ? -1 : event.getEffectInstance().m_19557_() / 20;
                attackEffects.addEffect(new MobEffectInstance(attackMobEffect.getAppliedEffect(), duration, event.getEffectInstance().m_19564_()));
            });
        }
    }

    @SubscribeEvent
    public static void addTimedEnchantmentsTooltips(ItemTooltipEvent event) {
        event.getItemStack().getCapability(TimedEnchantmentsCapabilityProvider.TIMED_ENCHANTMENTS).ifPresent(timedEnchantments -> {
            Player player = event.getEntity();
            if (player == null || timedEnchantments.getTimedEnchantments().isEmpty()) {
                return;
            }
            InventoryMenu abstractContainerMenu = player.f_36096_ instanceof CreativeModeInventoryScreen.ItemPickerMenu ? player.f_36095_ : player.f_36096_;
            ModPacketHandler.sendToServer(new AddTimedEnchantmentsTooltipsC2SPacket(abstractContainerMenu.m_38927_().indexOf((Object)event.getItemStack())));
            for (TimedEnchantment timedEnchantment : timedEnchantments.getTimedEnchantments()) {
                if (timedEnchantment == null) continue;
                Enchantment enchantment = timedEnchantment.getEnchantment();
                int index = event.getToolTip().lastIndexOf(enchantment.m_44700_(EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)event.getItemStack())));
                if (index == -1) continue;
                event.getToolTip().add(index, ((MutableComponent)enchantment.m_44700_(timedEnchantment.getLevel())).m_7220_((Component)Component.m_237110_((String)"tooltip.magical_staffs.duration", (Object[])new Object[]{StringUtil.m_14404_((int)timedEnchantments.getDisplayDuration(timedEnchantment.getId()))})).m_130940_(ChatFormatting.DARK_PURPLE));
            }
        });
    }

    @SubscribeEvent
    public static void applyAttackEffects(LivingAttackEvent event) {
        if (event.getSource().m_7639_() == null) {
            return;
        }
        event.getSource().m_7639_().getCapability(AttackEffectsCapabilityProvider.ATTACK_EFFECTS).ifPresent(attackEffects -> attackEffects.getEffects().forEach(attackEffect -> event.getEntity().m_7292_(new MobEffectInstance(attackEffect))));
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            AttackEffectsCapabilityProvider attackEffectsCapabilityProvider = new AttackEffectsCapabilityProvider();
            event.addCapability(AttackEffectsCapabilityProvider.KEY, (ICapabilityProvider)attackEffectsCapabilityProvider);
            event.addListener(attackEffectsCapabilityProvider::invalidateCaps);
        }
    }

    @SubscribeEvent
    public static void onAttachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (!((ItemStack)event.getObject()).m_150930_(Items.f_42517_) && (((ItemStack)event.getObject()).m_41792_() || ((ItemStack)event.getObject()).m_41793_())) {
            TimedEnchantmentsCapabilityProvider timedEnchantmentsCapabilityProvider = new TimedEnchantmentsCapabilityProvider((ItemStack)event.getObject());
            event.addCapability(TimedEnchantmentsCapabilityProvider.KEY, (ICapabilityProvider)timedEnchantmentsCapabilityProvider);
            event.addListener(timedEnchantmentsCapabilityProvider::invalidateCaps);
        }
        if (((ItemStack)event.getObject()).m_41720_() instanceof StaffItem) {
            TimerCapabilityProvider timerCapabilityProvider = new TimerCapabilityProvider();
            event.addCapability(TimerCapabilityProvider.KEY, (ICapabilityProvider)timerCapabilityProvider);
            event.addListener(timerCapabilityProvider::invalidateCaps);
        }
    }

    @SubscribeEvent
    public static void onAttachSavedData(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == ServerLevel.f_46428_) {
            serverLevel.m_8895_().m_164861_(TimedEnchantment::loadSavedData, TimedEnchantment::createSavedData, "timed_enchantment");
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getEntity().f_36095_.m_38893_((ContainerListener)new StaffItemListener());
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(AttackEffectsCapabilityInterface.class);
        event.register(TimedEnchantmentsCapabilityInterface.class);
        event.register(TimerCapabilityInterface.class);
    }

    @SubscribeEvent
    public static void removeAttackEffect(MobEffectEvent event) {
        if (!(event instanceof MobEffectEvent.Expired) && !(event instanceof MobEffectEvent.Remove)) {
            return;
        }
        MobEffect mobEffect = event.getEffectInstance().m_19544_();
        if (mobEffect instanceof AttackMobEffect) {
            AttackMobEffect attackMobEffect = (AttackMobEffect)mobEffect;
            event.getEntity().getCapability(AttackEffectsCapabilityProvider.ATTACK_EFFECTS).ifPresent(attackEffects -> attackEffects.removeEffect(attackMobEffect.getAppliedEffect()));
        }
    }

    @SubscribeEvent
    public static void timedEnchantmentTickDownDuration(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TimedEnchantment.TIMED_ENCHANTMENT_SAVED_DATA.getTimedEnchantmentList().removeIf(timedEnchantment -> timedEnchantment.tick(event.getServer().m_6846_().m_11314_()));
            TimedEnchantment.TIMED_ENCHANTMENT_SAVED_DATA.m_77762_();
        }
    }
}

