/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.item;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.andrew_coursin.magical_staffs.item.custom.StaffItem;
import net.andrew_coursin.magical_staffs.item.forge_material.ForgeMaterials;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"magical_staffs");
    public static final RegistryObject<SmithingTemplateItem> FORGE_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("forge_upgrade_smithing_template", ModItems::createForgeUpgradeTemplate);
    public static final RegistryObject<StaffItem> WOODEN_STAFF = ITEMS.register("wooden_staff", () -> new StaffItem(ForgeMaterials.WOOD.activeDuration(), ForgeMaterials.WOOD.coolDownFactor(), ForgeMaterials.WOOD.enchantmentSlots(), ForgeMaterials.WOOD.potionSlots(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<StaffItem> GOLDEN_STAFF = ITEMS.register("golden_staff", () -> new StaffItem(ForgeMaterials.GOLD.activeDuration(), ForgeMaterials.GOLD.coolDownFactor(), ForgeMaterials.GOLD.enchantmentSlots(), ForgeMaterials.GOLD.potionSlots(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<StaffItem> AMETHYST_STAFF = ITEMS.register("amethyst_staff", () -> new StaffItem(ForgeMaterials.AMETHYST.activeDuration(), ForgeMaterials.AMETHYST.coolDownFactor(), ForgeMaterials.AMETHYST.enchantmentSlots(), ForgeMaterials.AMETHYST.potionSlots(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<StaffItem> IRON_STAFF = ITEMS.register("iron_staff", () -> new StaffItem(ForgeMaterials.IRON.activeDuration(), ForgeMaterials.IRON.coolDownFactor(), ForgeMaterials.IRON.enchantmentSlots(), ForgeMaterials.IRON.potionSlots(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<StaffItem> DIAMOND_STAFF = ITEMS.register("diamond_staff", () -> new StaffItem(ForgeMaterials.DIAMOND.activeDuration(), ForgeMaterials.DIAMOND.coolDownFactor(), ForgeMaterials.DIAMOND.enchantmentSlots(), ForgeMaterials.DIAMOND.potionSlots(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<StaffItem> BLAZE_STAFF = ITEMS.register("blaze_staff", () -> new StaffItem(ForgeMaterials.BLAZE.activeDuration(), ForgeMaterials.BLAZE.coolDownFactor(), ForgeMaterials.BLAZE.enchantmentSlots(), ForgeMaterials.BLAZE.potionSlots(), new Item.Properties().m_41487_(1)));
    public static final RegistryObject<StaffItem> NETHERITE_STAFF = ITEMS.register("netherite_staff", () -> new StaffItem(ForgeMaterials.NETHERITE.activeDuration(), ForgeMaterials.NETHERITE.coolDownFactor(), ForgeMaterials.NETHERITE.enchantmentSlots(), ForgeMaterials.NETHERITE.potionSlots(), new Item.Properties().m_41487_(1)));

    public static SmithingTemplateItem createForgeUpgradeTemplate() {
        ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
        ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
        MutableComponent appliesTo = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("magical_staffs", "smithing_template.forge_upgrade.applies_to"))).m_130940_(DESCRIPTION_FORMAT);
        MutableComponent ingredients = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("magical_staffs", "smithing_template.forge_upgrade.ingredients"))).m_130940_(DESCRIPTION_FORMAT);
        MutableComponent upgradeDescription = Component.m_237115_((String)Util.m_137492_((String)"upgrade", (ResourceLocation)new ResourceLocation("magical_staffs", "forge_upgrade"))).m_130940_(TITLE_FORMAT);
        MutableComponent baseSlotDescription = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("magical_staffs", "smithing_template.forge_upgrade.base_slot_description")));
        MutableComponent additionsSlotDescription = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("magical_staffs", "smithing_template.forge_upgrade.additions_slot_description")));
        List<ResourceLocation> baseSlotEmptyIcons = List.of(new ResourceLocation("item/empty_slot_staff"));
        List<ResourceLocation> additionalSlotEmptyIcons = List.of(new ResourceLocation("block/empty_slot_block"), new ResourceLocation("item/empty_slot_ingot"), new ResourceLocation("item/empty_slot_amethyst_shard"), new ResourceLocation("item/empty_slot_diamond"), new ResourceLocation("item/empty_slot_blaze_rod"), new ResourceLocation("item/empty_slot_nether_star"), new ResourceLocation("item/empty_slot_dragon_breath"));
        return new SmithingTemplateItem((Component)appliesTo, (Component)ingredients, (Component)upgradeDescription, (Component)baseSlotDescription, (Component)additionsSlotDescription, baseSlotEmptyIcons, additionalSlotEmptyIcons);
    }

    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(WOODEN_STAFF);
            event.accept(GOLDEN_STAFF);
            event.accept(AMETHYST_STAFF);
            event.accept(IRON_STAFF);
            event.accept(DIAMOND_STAFF);
            event.accept(BLAZE_STAFF);
            event.accept(NETHERITE_STAFF);
        } else if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.accept(FORGE_UPGRADE_SMITHING_TEMPLATE);
        }
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

