/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.item.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantment;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantmentsCapabilityProvider;
import net.andrew_coursin.magical_staffs.capability.timer.TimerCapabilityInterface;
import net.andrew_coursin.magical_staffs.capability.timer.TimerCapabilityProvider;
import net.andrew_coursin.magical_staffs.effect.AttackMobEffect;
import net.andrew_coursin.magical_staffs.effect.ModEffects;
import net.andrew_coursin.magical_staffs.item.forge_material.ForgeMaterial;
import net.andrew_coursin.magical_staffs.item.forge_material.ForgeMaterials;
import net.andrew_coursin.magical_staffs.networking.ModPacketHandler;
import net.andrew_coursin.magical_staffs.networking.packet.SetTimerS2CPacket;
import net.andrew_coursin.magical_staffs.util.ModKeyBindings;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StaffItem
extends Item {
    private CompoundTag infuseEffect;
    private Enchantment absorbEnchantment;
    private int absorbLevel;
    private int index = -1;
    private int infuseLevel;
    private int newOtherLevel;
    private int newStaffLevel;
    private int newStaffPoints;
    private int newStaffSlots;
    private MobEffectInstance absorbPotion;
    private Modes mode = Modes.ABSORB;
    private final int activeDuration;
    private final int coolDownFactor;
    private final int maxEnchantmentSlots;
    private final int maxPotionSlots;
    public static String ENCHANTMENT_KEY = "magical_staffs.enchantments";
    public static String POTION_KEY = "magical_staffs.potions";
    public static String USED_ENCHANTMENT_SLOT_KEY = "magical_staffs.used_enchantment_slots";
    public static String USED_POTION_SLOT_KEY = "magical_staffs.used_potion_slots";

    public StaffItem(int pActiveDuration, int pCoolDownFactor, int pMaxEnchantmentSlots, int pMaxPotionSlots, Item.Properties properties) {
        super(properties);
        this.activeDuration = pActiveDuration;
        this.coolDownFactor = pCoolDownFactor;
        this.maxEnchantmentSlots = pMaxEnchantmentSlots;
        this.maxPotionSlots = pMaxPotionSlots;
    }

    private boolean infuseOther(boolean isEnchantment, CompoundTag staffCompoundTag, ItemStack otherItemStack, ItemStack staffItemStack, Player player) {
        if (isEnchantment) {
            Enchantment enchantment = StaffItem.getEnchantment(staffCompoundTag);
            if (enchantment == null) {
                StaffItem.message(true, player, Component.m_237110_((String)"message.magical_staffs.infuse.null", (Object[])new Object[]{"enchantment"}).getString());
                this.reset(false);
                return true;
            }
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)otherItemStack);
            enchantments.put(enchantment, this.newOtherLevel);
            if (otherItemStack.m_150930_(Items.f_42517_)) {
                ItemStack newItemStack = Items.f_42690_.m_7968_();
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)newItemStack);
                player.m_21008_(InteractionHand.OFF_HAND, ItemUtils.m_41813_((ItemStack)otherItemStack, (Player)player, (ItemStack)newItemStack));
            } else {
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)otherItemStack);
            }
        } else {
            MobEffect potion = StaffItem.getPotion(staffCompoundTag);
            if (potion == null) {
                StaffItem.message(true, player, Component.m_237110_((String)"message.magical_staffs.infuse.null", (Object[])new Object[]{"potion"}).getString());
                this.reset(false);
                return true;
            }
            List potions = PotionUtils.m_43547_((ItemStack)otherItemStack);
            int i = potions.size();
            int currentDuration = 0;
            for (MobEffectInstance mobEffectInstance : potions) {
                if (mobEffectInstance.m_19544_() != potion) continue;
                i = potions.indexOf(mobEffectInstance);
                currentDuration = mobEffectInstance.m_19557_();
                potions.remove(mobEffectInstance);
                break;
            }
            potions.add(i, new MobEffectInstance(potion, (currentDuration + this.getActiveDuration(staffItemStack)) / 2, this.newOtherLevel - 1));
            PotionUtils.m_43549_((ItemStack)otherItemStack, (Potion)Potions.f_43601_);
            PotionUtils.m_43552_((ItemStack)otherItemStack, (Collection)potions);
        }
        return false;
    }

    private double staffPointsInverse(boolean isEnchantment, int points) {
        return isEnchantment ? Math.log1p(points) / Math.log(2.0) : (-1.0 + Math.sqrt(1 + 8 * points)) / 2.0;
    }

    private int getActiveDuration(ItemStack staffItemStack) {
        ForgeMaterial forgeMaterial = StaffItem.getForgeMaterial(staffItemStack);
        if (forgeMaterial.activeDuration() == Integer.MIN_VALUE) {
            return this.activeDuration;
        }
        return (this.activeDuration + forgeMaterial.activeDuration()) / 2;
    }

    private int getCoolDownDuration(ItemStack staffItemStack) {
        ForgeMaterial forgeMaterial = StaffItem.getForgeMaterial(staffItemStack);
        if (forgeMaterial.coolDownFactor() == Integer.MIN_VALUE) {
            return this.getActiveDuration(staffItemStack) / this.coolDownFactor;
        }
        return 2 * this.getActiveDuration(staffItemStack) / (this.coolDownFactor + forgeMaterial.coolDownFactor());
    }

    private int getMaxSlots(boolean isEnchantment, ItemStack staffItemStack) {
        ForgeMaterial forgeMaterial = StaffItem.getForgeMaterial(staffItemStack);
        if (isEnchantment) {
            return this.maxEnchantmentSlots - Math.floorDiv(forgeMaterial.enchantmentSlots(), -2);
        }
        return this.maxPotionSlots - Math.floorDiv(forgeMaterial.potionSlots(), -2);
    }

    private int otherLevelToPoints(boolean isEnchantment, int level) {
        return isEnchantment ? (int)Math.pow(2.0, level - 1) : level;
    }

    private int staffSlotsToPoints(boolean isEnchantment, int slots) {
        return isEnchantment ? (int)(Math.pow(2.0, slots) - 1.0) : slots * (slots + 1) / 2;
    }

    private void absorbOther(boolean isEnchantment, Player player) {
        if (player.m_7500_()) {
            return;
        }
        if (isEnchantment) {
            ListTag otherEnchantments;
            ItemStack otherItemStack = player.m_21206_();
            boolean isEnchantedBook = otherItemStack.m_150930_(Items.f_42690_);
            ListTag listTag = otherEnchantments = isEnchantedBook ? EnchantedBookItem.m_41163_((ItemStack)otherItemStack) : otherItemStack.m_41785_();
            if (this.newOtherLevel > 0) {
                EnchantmentHelper.m_182440_((CompoundTag)otherEnchantments.m_128728_(this.index), (int)this.newOtherLevel);
                return;
            }
            otherEnchantments.remove(this.index);
            if (otherEnchantments.isEmpty()) {
                if (isEnchantedBook) {
                    player.m_21008_(InteractionHand.OFF_HAND, Items.f_42517_.m_7968_());
                } else {
                    otherItemStack.m_41749_("Enchantments");
                }
            }
        } else {
            player.m_21195_(this.absorbPotion.m_19544_());
            if (this.newOtherLevel > 0) {
                player.m_7292_(new MobEffectInstance(this.absorbPotion.m_19544_(), this.absorbPotion.m_19557_(), this.newOtherLevel - 1));
            }
        }
    }

    private void appendEnchantments(ItemStack staffItemStack, List<Component> tooltipComponents) {
        ArrayList<MutableComponent> enchantmentComponents = new ArrayList<MutableComponent>();
        ListTag storedEnchantments = StaffItem.getStoredEffects(true, staffItemStack);
        for (Tag tag : storedEnchantments) {
            CompoundTag compoundTag = (CompoundTag)tag;
            Enchantment enchantment = StaffItem.getEnchantment(compoundTag);
            if (enchantment == null) continue;
            int level = EnchantmentHelper.m_182438_((CompoundTag)compoundTag);
            int slots = compoundTag.m_128451_("slots");
            enchantmentComponents.add(Component.m_237110_((String)"tooltip.magical_staffs.effect", (Object[])new Object[]{enchantment.m_44700_(level), slots}).m_130940_(ChatFormatting.BLUE));
            if (!Screen.m_96638_()) continue;
            int currentPoints = compoundTag.m_128451_("pts");
            int nextPoints = this.staffSlotsToPoints(true, slots);
            enchantmentComponents.add(Component.m_237110_((String)"tooltip.magical_staffs.effect_extra", (Object[])new Object[]{currentPoints, nextPoints, enchantment.m_44700_(slots).getString()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.magical_staffs.enchantment_slots", (Object[])new Object[]{StaffItem.getUsedSlots(true, staffItemStack), this.getMaxSlots(true, staffItemStack)}).m_130940_(ChatFormatting.DARK_PURPLE));
        tooltipComponents.addAll(enchantmentComponents);
    }

    private void appendPotions(ItemStack staffItemStack, List<Component> tooltipComponents) {
        ArrayList<MutableComponent> potionComponents = new ArrayList<MutableComponent>();
        ListTag storedPotions = StaffItem.getStoredEffects(false, staffItemStack);
        for (Tag tag : storedPotions) {
            CompoundTag compoundTag = (CompoundTag)tag;
            MobEffect potion = StaffItem.getPotion(compoundTag);
            if (potion == null) continue;
            MutableComponent id = Component.m_237115_((String)potion.m_19481_());
            MutableComponent lvl = Component.m_237115_((String)("potion.potency." + (compoundTag.m_128451_("lvl") - 1)));
            int slots = compoundTag.m_128451_("slots");
            potionComponents.add(Component.m_237110_((String)"tooltip.magical_staffs.effect", (Object[])new Object[]{Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{id, lvl}).m_130940_(potion.m_19483_().m_19497_()), slots}).m_130940_(ChatFormatting.BLUE));
            if (!Screen.m_96638_()) continue;
            int currentPoints = compoundTag.m_128451_("pts");
            int nextPoints = this.staffSlotsToPoints(false, slots);
            MutableComponent nextLvl = Component.m_237115_((String)("potion.potency." + (slots - 1)));
            potionComponents.add(Component.m_237110_((String)"tooltip.magical_staffs.effect_extra", (Object[])new Object[]{currentPoints, nextPoints, Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{id, nextLvl})}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.magical_staffs.potion_slots", (Object[])new Object[]{StaffItem.getUsedSlots(false, staffItemStack), this.getMaxSlots(false, staffItemStack)}).m_130940_(ChatFormatting.DARK_PURPLE));
        tooltipComponents.addAll(potionComponents);
    }

    private void completeAbsorb(Player player) {
        if (this.absorbEnchantment == null && this.absorbPotion == null) {
            StaffItem.message(false, player, Component.m_237115_((String)"message.magical_staffs.no_choices").getString());
            return;
        }
        if (player.f_36078_ < this.newStaffLevel && !player.m_7500_()) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.no_experience", (Object[])new Object[]{this.newStaffLevel}).getString());
            return;
        }
        ItemStack staffItemStack = player.m_21205_();
        boolean isEnchantment = this.absorbEnchantment != null;
        ListTag staffStoredEffects = StaffItem.getStoredEffects(isEnchantment, staffItemStack);
        CompoundTag staffCompoundTag = StaffItem.getCompoundById(staffStoredEffects, isEnchantment ? StaffItem.getEnchantmentId(this.absorbEnchantment) : StaffItem.getPotionId(this.absorbPotion.m_19544_()));
        int currentStaffSlots = staffCompoundTag.m_128451_("slots");
        int usedStaffSlots = StaffItem.getUsedSlots(isEnchantment, staffItemStack);
        StaffItem.setUsedSlots(isEnchantment, usedStaffSlots + this.newStaffSlots - currentStaffSlots, staffItemStack);
        staffCompoundTag.m_128405_("lvl", this.newStaffLevel);
        staffCompoundTag.m_128405_("pts", this.newStaffPoints);
        staffCompoundTag.m_128405_("slots", this.newStaffSlots);
        if (!staffStoredEffects.contains((Object)staffCompoundTag)) {
            staffStoredEffects.add((Object)staffCompoundTag);
        }
        staffItemStack.m_41700_(isEnchantment ? ENCHANTMENT_KEY : POTION_KEY, (Tag)staffStoredEffects);
        this.absorbOther(isEnchantment, player);
        StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.absorb.complete", (Object[])new Object[]{isEnchantment ? "Enchantment" : "Potion"}).getString());
        player.m_6749_(-1 * this.newStaffLevel);
        player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.reset(false);
    }

    private void completeInfuse(Player player) {
        if (this.infuseEffect == null) {
            StaffItem.message(false, player, Component.m_237115_((String)"message.magical_staffs.no_choices").getString());
            this.reset(false);
            return;
        }
        if (player.f_36078_ < this.newOtherLevel && !player.m_7500_()) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.no_experience", (Object[])new Object[]{this.newOtherLevel}).getString());
            this.reset(false);
            return;
        }
        ItemStack staffItemStack = player.m_21205_();
        ItemStack otherItemStack = player.m_21206_();
        boolean isEnchantment = !otherItemStack.m_150930_(Items.f_42589_);
        ListTag staffStoredEffects = StaffItem.getStoredEffects(isEnchantment, staffItemStack);
        String id = this.infuseEffect.m_128461_("id");
        CompoundTag staffCompoundTag = StaffItem.getCompoundById(staffStoredEffects, id);
        int currentStaffSlots = staffCompoundTag.m_128451_("slots");
        int usedStaffSlots = StaffItem.getUsedSlots(isEnchantment, staffItemStack);
        StaffItem.setUsedSlots(isEnchantment, usedStaffSlots + this.newStaffSlots - currentStaffSlots, staffItemStack);
        if (this.newStaffLevel == 0) {
            staffStoredEffects.remove(this.index);
        } else {
            staffCompoundTag.m_128405_("lvl", this.newStaffLevel);
            staffCompoundTag.m_128405_("pts", this.newStaffPoints);
            staffCompoundTag.m_128405_("slots", this.newStaffSlots);
        }
        staffItemStack.m_41700_(isEnchantment ? ENCHANTMENT_KEY : POTION_KEY, (Tag)staffStoredEffects);
        if (this.infuseOther(isEnchantment, staffCompoundTag, otherItemStack, staffItemStack, player)) {
            return;
        }
        StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.complete", (Object[])new Object[]{isEnchantment ? "Enchantment" : "Potion"}).getString());
        player.m_6749_(-1 * this.newOtherLevel);
        player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.reset(false);
    }

    private void cycleMode(Player player) {
        switch (this.mode) {
            case ABSORB: {
                this.mode = Modes.INFUSE;
                break;
            }
            case INFUSE: {
                this.mode = Modes.IMBUE;
                break;
            }
            case IMBUE: {
                this.mode = Modes.ABSORB;
            }
        }
        StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.mode_selected", (Object[])new Object[]{Component.m_237115_((String)("message.magical_staffs." + this.mode.toString().toLowerCase(Locale.ROOT)))}).getString());
        this.reset(true);
    }

    private void imbue(ItemStack staffItemStack, Player player) {
        ListTag staffEnchantments = staffItemStack.m_41784_().m_128437_(ENCHANTMENT_KEY, 10);
        ListTag staffPotions = staffItemStack.m_41784_().m_128437_(POTION_KEY, 10);
        if (staffEnchantments.isEmpty() && staffPotions.isEmpty()) {
            StaffItem.message(false, player, Component.m_237115_((String)"message.magical_staffs.imbue.no_effects").getString());
            return;
        }
        int experienceCost = StaffItem.getUsedSlots(true, staffItemStack) + StaffItem.getUsedSlots(false, staffItemStack);
        if (player.f_36078_ < experienceCost && !player.m_7500_()) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.no_experience", (Object[])new Object[]{experienceCost}).getString());
            return;
        }
        this.imbueEnchantments(staffItemStack, staffEnchantments, player);
        this.imbuePotions(staffItemStack, staffPotions, player);
        player.m_6749_(-1 * experienceCost);
        player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        staffItemStack.getCapability(TimerCapabilityProvider.TIMER).ifPresent(timer -> timer.setTime(this.getActiveDuration(staffItemStack) + this.getCoolDownDuration(staffItemStack)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                if (player.m_150109_().m_8020_(i).m_41619_() || !ItemStack.m_150942_((ItemStack)staffItemStack, (ItemStack)player.m_150109_().m_8020_(i))) continue;
                ModPacketHandler.sendToPlayer(new SetTimerS2CPacket(i, this.getActiveDuration(staffItemStack) + this.getCoolDownDuration(staffItemStack)), serverPlayer);
                break;
            }
        }
    }

    private void imbueEnchantments(ItemStack staffItemStack, ListTag staffEnchantments, Player player) {
        for (Tag tag : staffEnchantments) {
            CompoundTag staffCompoundTag = (CompoundTag)tag;
            Enchantment staffEnchantment = StaffItem.getEnchantment(staffCompoundTag);
            if (staffEnchantment == null) continue;
            int addLevel = staffCompoundTag.m_128451_("lvl");
            TimedEnchantment timedEnchantment = new TimedEnchantment(staffEnchantment, this.getActiveDuration(staffItemStack), addLevel);
            for (ItemStack otherItemStack : player.f_36096_.m_38927_()) {
                if (!staffEnchantment.m_6081_(otherItemStack)) continue;
                Map otherEnchantments = EnchantmentHelper.m_44831_((ItemStack)otherItemStack);
                int newLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)staffEnchantment, (ItemStack)otherItemStack) + addLevel;
                otherEnchantments.put(staffEnchantment, newLevel);
                EnchantmentHelper.m_44865_((Map)otherEnchantments, (ItemStack)otherItemStack);
                otherItemStack.getCapability(TimedEnchantmentsCapabilityProvider.TIMED_ENCHANTMENTS).ifPresent(timedEnchantments -> timedEnchantments.addTimedEnchantment(timedEnchantment));
            }
        }
    }

    private void imbuePotions(ItemStack staffItemStack, ListTag staffPotions, Player player) {
        for (Tag tag : staffPotions) {
            MobEffect potion = StaffItem.getPotion((CompoundTag)tag);
            AttackMobEffect attackMobEffect = ModEffects.getAttackEffect(potion);
            int amplifier = ((CompoundTag)tag).m_128451_("lvl") - 1;
            if (potion == null) continue;
            if (potion.m_19486_()) {
                MobEffectInstance mobEffectInstance = player.m_21124_(potion);
                player.m_7292_(new MobEffectInstance(potion, this.getActiveDuration(staffItemStack), amplifier + (mobEffectInstance != null ? mobEffectInstance.m_19564_() + 1 : 0)));
                continue;
            }
            if (attackMobEffect == null) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)attackMobEffect, this.getActiveDuration(staffItemStack), amplifier));
        }
    }

    private void prepareAbsorb(boolean isEnchantment, int indexIncrement, ItemStack staffItemStack, Player player) {
        String type;
        ItemStack otherItemStack = player.m_21206_();
        Map otherEnchantments = isEnchantment ? EnchantmentHelper.m_44831_((ItemStack)otherItemStack) : null;
        Collection otherPotions = !isEnchantment ? player.m_21220_() : null;
        String string = type = isEnchantment ? "enchantment" : "potion";
        if (isEnchantment && otherEnchantments.isEmpty() || !isEnchantment && otherPotions.isEmpty()) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.absorb.no_effect", (Object[])new Object[]{type}).getString());
            this.reset(false);
            return;
        }
        int size = isEnchantment ? otherEnchantments.size() : otherPotions.size();
        this.index = (this.index + indexIncrement + size) % size;
        this.absorbEnchantment = isEnchantment ? (Enchantment)otherEnchantments.keySet().toArray()[this.index] : null;
        this.absorbPotion = !isEnchantment ? (MobEffectInstance)otherPotions.toArray()[this.index] : null;
        String name = isEnchantment ? StaffItem.getEnchantmentId(this.absorbEnchantment) : StaffItem.getPotionId(this.absorbPotion.m_19544_());
        ListTag staffStoredEffects = StaffItem.getStoredEffects(isEnchantment, staffItemStack);
        CompoundTag staffCompoundTag = StaffItem.getCompoundById(staffStoredEffects, name);
        int currentStaffPoints = staffCompoundTag.m_128451_("pts");
        int currentStaffLevel = staffCompoundTag.m_128451_("lvl");
        int currentStaffSlots = staffCompoundTag.m_128451_("slots");
        int usedStaffSlots = StaffItem.getUsedSlots(isEnchantment, staffItemStack);
        MutableComponent nameComponent = Component.m_237115_((String)(isEnchantment ? this.absorbEnchantment.m_44704_() : this.absorbPotion.m_19576_()));
        if (isEnchantment && currentStaffLevel >= this.absorbEnchantment.m_6586_()) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.absorb.max_level", (Object[])new Object[]{nameComponent, Component.m_237115_((String)("enchantment.level." + this.absorbEnchantment.m_6586_()))}).getString());
            this.reset(false);
            return;
        }
        int currentOtherLevel = isEnchantment ? (Integer)otherEnchantments.get(this.absorbEnchantment) : this.absorbPotion.m_19564_() + 1;
        int currentOtherPoints = this.otherLevelToPoints(isEnchantment, currentOtherLevel);
        if (this.absorbLevel > currentOtherLevel) {
            this.absorbLevel = currentOtherLevel;
        }
        if (this.absorbLevel < 1) {
            this.absorbLevel = 1;
        }
        this.newOtherLevel = currentOtherLevel - this.absorbLevel;
        int newOtherPoints = this.otherLevelToPoints(isEnchantment, this.newOtherLevel);
        int deltaPoints = currentOtherPoints - newOtherPoints;
        int slotLimit = Math.min(this.getMaxSlots(isEnchantment, staffItemStack) - usedStaffSlots + currentStaffSlots, isEnchantment ? this.absorbEnchantment.m_6586_() : Integer.MAX_VALUE);
        int pointLimit = this.staffSlotsToPoints(isEnchantment, slotLimit);
        if (currentStaffPoints >= pointLimit) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.absorb.no_slots", (Object[])new Object[]{type}).getString());
            this.reset(false);
            return;
        }
        this.newStaffPoints = Math.min(currentStaffPoints + deltaPoints, pointLimit);
        double inverse = this.staffPointsInverse(isEnchantment, this.newStaffPoints);
        this.newStaffLevel = (int)Math.floor(inverse);
        this.newStaffSlots = (int)Math.ceil(inverse);
        String pKey = isEnchantment ? "enchantment.level." : "potion.potency.";
        int adjustment = isEnchantment ? 0 : 1;
        MutableComponent newOtherLevelComponent = this.newOtherLevel - adjustment > 0 ? Component.m_237115_((String)(pKey + (this.newOtherLevel - adjustment))) : Component.m_237113_((String)"");
        MutableComponent newStaffLevelComponent = this.newStaffLevel - adjustment > 0 ? Component.m_237115_((String)(pKey + (this.newStaffLevel - adjustment))) : Component.m_237113_((String)"");
        StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.absorb.prepare", (Object[])new Object[]{nameComponent, newStaffLevelComponent, this.newStaffPoints, this.newStaffSlots, newOtherLevelComponent}).getString());
    }

    private void prepareInfuse(boolean isEnchantment, int indexIncrement, ItemStack staffItemStack, Player player) {
        int currentOtherLevel;
        Enchantment effect;
        ItemStack otherItemStack = player.m_21206_();
        ListTag staffEffects = StaffItem.getStoredEffects(isEnchantment, staffItemStack);
        if (otherItemStack.m_41619_()) {
            StaffItem.message(false, player, Component.m_237115_((String)"message.magical_staffs.infuse.no_item").getString());
            this.reset(false);
            return;
        }
        if (staffEffects.isEmpty()) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.no_effect", (Object[])new Object[]{isEnchantment ? "enchantment" : "potion"}).getString());
            this.reset(false);
            return;
        }
        this.index = (this.index + indexIncrement + staffEffects.size()) % staffEffects.size();
        this.infuseEffect = staffEffects.m_128728_(this.index);
        Object object = effect = isEnchantment ? StaffItem.getEnchantment(this.infuseEffect) : StaffItem.getPotion(this.infuseEffect);
        if (effect == null) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.null", (Object[])new Object[]{isEnchantment ? "enchantment" : "potion"}).getString());
            this.reset(false);
            return;
        }
        MutableComponent nameComponent = Component.m_237115_((String)(isEnchantment ? effect.m_44704_() : ((MobEffect)effect).m_19481_()));
        int n = currentOtherLevel = isEnchantment ? StaffItem.getEnchantmentLevel(this.infuseEffect, otherItemStack) : StaffItem.getPotionLevel(this.infuseEffect, otherItemStack);
        if (this.infuseLevel > currentOtherLevel) {
            this.infuseLevel = currentOtherLevel;
        }
        if (this.infuseLevel < 1) {
            this.infuseLevel = 1;
        }
        this.newOtherLevel = currentOtherLevel + this.infuseLevel;
        if (isEnchantment) {
            Enchantment enchantment = effect;
            if (!(enchantment.m_6081_(otherItemStack) || otherItemStack.m_150930_(Items.f_42517_) || otherItemStack.m_150930_(Items.f_42690_))) {
                StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.can_not_enchant", (Object[])new Object[]{nameComponent}).getString());
                this.reset(false);
                return;
            }
            if (this.newOtherLevel > enchantment.m_6586_()) {
                StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.max_level", (Object[])new Object[]{nameComponent, Component.m_237115_((String)("enchantment.level." + enchantment.m_6586_()))}).getString());
                this.reset(false);
                return;
            }
        }
        int currentOtherPoints = this.otherLevelToPoints(isEnchantment, currentOtherLevel);
        int currentStaffPoints = this.infuseEffect.m_128451_("pts");
        int newOtherPoints = this.otherLevelToPoints(isEnchantment, this.newOtherLevel);
        this.newStaffPoints = currentStaffPoints - newOtherPoints + currentOtherPoints;
        if (this.newStaffPoints < 0) {
            StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.no_points", (Object[])new Object[]{isEnchantment ? "enchantment" : "potion", newOtherPoints - currentOtherPoints}).getString());
            this.reset(false);
            return;
        }
        double inverse = this.staffPointsInverse(isEnchantment, this.newStaffPoints);
        this.newStaffLevel = (int)Math.floor(inverse);
        this.newStaffSlots = (int)Math.ceil(inverse);
        String pKey = isEnchantment ? "enchantment.level." : "potion.potency.";
        int adjustment = isEnchantment ? 0 : 1;
        MutableComponent newOtherLevelComponent = this.newOtherLevel - adjustment > 0 ? Component.m_237115_((String)(pKey + (this.newOtherLevel - adjustment))) : Component.m_237113_((String)"");
        MutableComponent newStaffLevelComponent = this.newStaffLevel - adjustment > 0 ? Component.m_237115_((String)(pKey + (this.newStaffLevel - adjustment))) : Component.m_237113_((String)"");
        StaffItem.message(false, player, Component.m_237110_((String)"message.magical_staffs.infuse.prepare", (Object[])new Object[]{nameComponent, newStaffLevelComponent, this.newStaffPoints, this.newStaffSlots, newOtherLevelComponent}).getString());
    }

    private static CompoundTag getCompoundById(ListTag listTag, String id) {
        for (Tag tag : listTag) {
            CompoundTag compoundTag;
            if (!(tag instanceof CompoundTag) || !(compoundTag = (CompoundTag)tag).m_128461_("id").equals(id)) continue;
            return compoundTag;
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("id", id);
        compoundTag.m_128405_("lvl", 0);
        compoundTag.m_128405_("pts", 0);
        compoundTag.m_128405_("slots", 0);
        return compoundTag;
    }

    private static ForgeMaterial getForgeMaterial(ItemStack staffItemStack) {
        if (staffItemStack.m_41784_().m_128441_(ForgeMaterials.KEY)) {
            return ForgeMaterials.getForgeMaterialFromName(staffItemStack.m_41784_().m_128461_(ForgeMaterials.KEY));
        }
        return ForgeMaterials.NONE;
    }

    private static int getEnchantmentLevel(CompoundTag compoundTag, ItemStack otherItemStack) {
        return EnchantmentHelper.m_44831_((ItemStack)otherItemStack).getOrDefault(StaffItem.getEnchantment(compoundTag), 0);
    }

    private static int getPotionLevel(CompoundTag compoundTag, ItemStack otherItemStack) {
        List potions = PotionUtils.m_43566_((CompoundTag)otherItemStack.m_41784_());
        for (MobEffectInstance potion : potions) {
            if (!StaffItem.getPotionId(potion.m_19544_()).equals(compoundTag.m_128461_("id"))) continue;
            return potion.m_19564_() + 1;
        }
        return 0;
    }

    private static int getUsedSlots(boolean isEnchantment, ItemStack staffItemStack) {
        return staffItemStack.m_41784_().m_128451_(isEnchantment ? USED_ENCHANTMENT_SLOT_KEY : USED_POTION_SLOT_KEY);
    }

    private static ListTag getStoredEffects(boolean isEnchantment, ItemStack staffItemStack) {
        return staffItemStack.m_41784_().m_128437_(isEnchantment ? ENCHANTMENT_KEY : POTION_KEY, 10);
    }

    private static String getEnchantmentId(Enchantment enchantment) {
        return String.valueOf(EnchantmentHelper.m_182432_((Enchantment)enchantment));
    }

    private static String getPotionId(MobEffect mobEffect) {
        return String.valueOf(ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect));
    }

    private static void message(boolean debug, Player player, String string) {
        if (!debug) {
            player.m_5661_((Component)Component.m_237113_((String)string), true);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)string));
        }
    }

    private static void setUsedSlots(boolean isEnchantment, int usedSlots, ItemStack staffItemStack) {
        staffItemStack.m_41784_().m_128405_(isEnchantment ? USED_ENCHANTMENT_SLOT_KEY : USED_POTION_SLOT_KEY, usedSlots);
    }

    @Nullable
    private static Enchantment getEnchantment(CompoundTag compoundTag) {
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compoundTag));
    }

    @Nullable
    private static MobEffect getPotion(CompoundTag compoundTag) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)compoundTag.m_128461_("id")));
    }

    public boolean canForge(ItemStack staffItemStack) {
        return StaffItem.getUsedSlots(true, staffItemStack) <= this.getMaxSlots(true, staffItemStack) && StaffItem.getUsedSlots(false, staffItemStack) <= this.getMaxSlots(false, staffItemStack);
    }

    public void reset(boolean resetIndex) {
        this.absorbEnchantment = null;
        this.absorbPotion = null;
        this.infuseEffect = null;
        this.newStaffLevel = 0;
        this.newStaffPoints = 0;
        this.newStaffSlots = 0;
        if (resetIndex) {
            this.index = 0;
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        if (pStack.getCapability(TimerCapabilityProvider.TIMER).resolve().isEmpty()) {
            return false;
        }
        return ((TimerCapabilityInterface)pStack.getCapability(TimerCapabilityProvider.TIMER).resolve().get()).getTime() == 0;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case Modes.ABSORB, Modes.INFUSE -> false;
            case Modes.IMBUE -> true;
        };
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (!this.m_5812_(itemStack)) {
            itemStack.getCapability(TimerCapabilityProvider.TIMER).ifPresent(timer -> StaffItem.message(false, pPlayer, Component.m_237110_((String)"message.magical_staffs.on_cool_down", (Object[])new Object[]{StringUtil.m_14404_((int)timer.getTime())}).getString()));
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (pLevel.m_5776_()) {
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if (pPlayer.m_36341_()) {
            this.cycleMode(pPlayer);
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        switch (this.mode) {
            case ABSORB: {
                if (pUsedHand != InteractionHand.MAIN_HAND) break;
                this.completeAbsorb(pPlayer);
                break;
            }
            case INFUSE: {
                if (pUsedHand != InteractionHand.MAIN_HAND) break;
                this.completeInfuse(pPlayer);
                break;
            }
            case IMBUE: {
                this.imbue(itemStack, pPlayer);
            }
        }
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPYGLASS;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.magical_staffs.when_used").m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.magical_staffs.active_duration", (Object[])new Object[]{StringUtil.m_14404_((int)this.getActiveDuration(pStack))}).m_130940_(ChatFormatting.DARK_GREEN));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.magical_staffs.cool_down_duration", (Object[])new Object[]{StringUtil.m_14404_((int)this.getCoolDownDuration(pStack))}).m_130940_(ChatFormatting.DARK_GREEN));
        pTooltipComponents.add(CommonComponents.f_237098_);
        this.appendEnchantments(pStack, pTooltipComponents);
        pTooltipComponents.add(CommonComponents.f_237098_);
        this.appendPotions(pStack, pTooltipComponents);
        if (!Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.magical_staffs.extra_info").m_130940_(ChatFormatting.DARK_GRAY));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private static enum Modes {
        ABSORB,
        INFUSE,
        IMBUE;

    }

    @Mod.EventBusSubscriber(modid="magical_staffs", value={Dist.CLIENT})
    public static class StaffItemEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                StaffItem staffItem;
                Item item;
                LocalPlayer player;
                while (ModKeyBindings.CYCLE_EFFECTS_FORWARD.m_90859_()) {
                    player = Minecraft.m_91087_().f_91074_;
                    if (player == null) {
                        return;
                    }
                    item = player.m_21205_().m_41720_();
                    if (!(item instanceof StaffItem)) continue;
                    staffItem = (StaffItem)item;
                    switch (staffItem.mode) {
                        case ABSORB: {
                            staffItem.absorbLevel = 1;
                            staffItem.prepareAbsorb(!player.m_21206_().m_41619_(), 1, player.m_21205_(), (Player)player);
                            break;
                        }
                        case INFUSE: {
                            staffItem.infuseLevel = 1;
                            staffItem.prepareInfuse(!player.m_21206_().m_150930_(Items.f_42589_), 1, player.m_21205_(), (Player)player);
                        }
                    }
                }
                while (ModKeyBindings.CYCLE_EFFECTS_BACKWARD.m_90859_()) {
                    player = Minecraft.m_91087_().f_91074_;
                    if (player == null) {
                        return;
                    }
                    item = player.m_21205_().m_41720_();
                    if (!(item instanceof StaffItem)) continue;
                    staffItem = (StaffItem)item;
                    switch (staffItem.mode) {
                        case ABSORB: {
                            staffItem.absorbLevel = 1;
                            staffItem.prepareAbsorb(!player.m_21206_().m_41619_(), -1, player.m_21205_(), (Player)player);
                            break;
                        }
                        case INFUSE: {
                            staffItem.infuseLevel = 1;
                            staffItem.prepareInfuse(!player.m_21206_().m_150930_(Items.f_42589_), -1, player.m_21205_(), (Player)player);
                        }
                    }
                }
                while (ModKeyBindings.CYCLE_EFFECTS_INCREASE.m_90859_()) {
                    player = Minecraft.m_91087_().f_91074_;
                    if (player == null) {
                        return;
                    }
                    item = player.m_21205_().m_41720_();
                    if (!(item instanceof StaffItem)) continue;
                    staffItem = (StaffItem)item;
                    switch (staffItem.mode) {
                        case ABSORB: {
                            ++staffItem.absorbLevel;
                            staffItem.prepareAbsorb(!player.m_21206_().m_41619_(), 0, player.m_21205_(), (Player)player);
                            break;
                        }
                        case INFUSE: {
                            ++staffItem.infuseLevel;
                            staffItem.prepareInfuse(!player.m_21206_().m_150930_(Items.f_42589_), 0, player.m_21205_(), (Player)player);
                        }
                    }
                }
                while (ModKeyBindings.CYCLE_EFFECTS_DECREASE.m_90859_()) {
                    player = Minecraft.m_91087_().f_91074_;
                    if (player == null) {
                        return;
                    }
                    item = player.m_21205_().m_41720_();
                    if (!(item instanceof StaffItem)) continue;
                    staffItem = (StaffItem)item;
                    switch (staffItem.mode) {
                        case ABSORB: {
                            --staffItem.absorbLevel;
                            staffItem.prepareAbsorb(!player.m_21206_().m_41619_(), 0, player.m_21205_(), (Player)player);
                            break;
                        }
                        case INFUSE: {
                            --staffItem.infuseLevel;
                            staffItem.prepareInfuse(!player.m_21206_().m_150930_(Items.f_42589_), 0, player.m_21205_(), (Player)player);
                        }
                    }
                }
            }
        }
    }
}

