/*
 * Decompiled with CFR 0.152.
 */
package net.andrew_coursin.magical_staffs.networking.packet;

import java.util.function.Supplier;
import net.andrew_coursin.magical_staffs.capability.timed_enchantment.TimedEnchantmentsCapabilityProvider;
import net.andrew_coursin.magical_staffs.networking.ModPacketHandler;
import net.andrew_coursin.magical_staffs.networking.packet.AddTimedEnchantmentsTooltipsS2CPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class AddTimedEnchantmentsTooltipsC2SPacket {
    private final int slot;

    public AddTimedEnchantmentsTooltipsC2SPacket(FriendlyByteBuf pBuffer) {
        this.slot = pBuffer.readByte();
    }

    public AddTimedEnchantmentsTooltipsC2SPacket(int pSlot) {
        this.slot = pSlot;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ((ItemStack)player.f_36096_.m_38927_().get(this.slot)).getCapability(TimedEnchantmentsCapabilityProvider.TIMED_ENCHANTMENTS).ifPresent(timedEnchantments -> ModPacketHandler.sendToPlayer(new AddTimedEnchantmentsTooltipsS2CPacket(timedEnchantments.serializeDurations(), this.slot), player));
        });
        context.setPacketHandled(true);
    }

    public void toBytes(FriendlyByteBuf pBuffer) {
        pBuffer.writeByte(this.slot);
    }
}

