/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleFallingLiquid
extends TextureSheetParticle {
    private final Fluid fluidType;
    private final ParticleOptions splashParticle;

    public ParticleFallingLiquid(ClientLevel level, double x, double y, double z, Fluid fluid, ParticleOptions splash) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.fluidType = fluid;
        this.splashParticle = splash;
        this.lifetime = (int)(64.0 / (Math.random() * 0.8 + 0.2));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
            return;
        }
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (!this.removed) {
                this.xd *= 0.98;
                this.yd *= 0.98;
                this.zd *= 0.98;
                BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
                FluidState state = this.level.getFluidState(pos);
                if (state.getType() == this.fluidType && this.y < (double)((float)pos.getY() + state.getHeight((BlockGetter)this.level, pos))) {
                    this.remove();
                }
                if (this.onGround) {
                    this.remove();
                    this.level.addParticle(this.splashParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FactoryWaterRandom
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public FactoryWaterRandom(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (RandomSource.create().nextBoolean()) {
                ParticleFallingLiquid particle = new ParticleFallingLiquid(level, x, y, z, (Fluid)Fluids.WATER, (ParticleOptions)ParticleTypes.SPLASH);
                particle.setColor(0.2f, 0.3f, 1.0f);
                particle.pickSprite(this.sprites);
                return particle;
            }
            return null;
        }
    }
}

