/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.containers;

import com.razznature.decocraft.common.ModuleBlocks;
import com.razznature.decocraft.common.ModuleItems;
import com.razznature.decocraft.common.ModuleScreenHandlers;
import com.razznature.decocraft.common.tileentities.DecobenchTileEntity;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DecobenchScreenHandler
extends AbstractContainerMenu {
    public static final int ROWS = 4;
    public static final int COLUMNS = 7;
    public static final int CONTAINER_SLOT_ID = 11;
    private static final SimpleContainer CONTAINER = new SimpleContainer(28);
    private static final int FIRST_ROW = 37;
    private static final int FIRST_COLUMNS = 54;
    private static final int SPACING = 18;
    private static final int INVENTORY_X = 22;
    private static final int INVENTORY_Y = 147;
    public final NonNullList<ItemStack> items = NonNullList.create();
    private final ContainerLevelAccess context;
    public int[] colors = new int[3];
    public int[] rawMaterial = new int[1];
    public int[] crafting = new int[2];
    private DecobenchTileEntity decobenchTE;
    private Level world;

    public DecobenchScreenHandler(int syncId, Inventory inventory) {
        this(syncId, inventory, ContainerLevelAccess.NULL);
    }

    public DecobenchScreenHandler(int syncId, Inventory inventory, ContainerLevelAccess context) {
        super((MenuType)ModuleScreenHandlers.DECOBENCH.get(), syncId);
        this.context = context;
        this.context.execute((world, pos) -> {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            this.decobenchTE = blockEntity instanceof DecobenchTileEntity ? (DecobenchTileEntity)blockEntity : null;
            this.world = world;
        });
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 22 + i * 18, 147));
        }
        SimpleContainer inputInventory = this.decobenchTE != null ? this.decobenchTE.getInput() : new SimpleContainer(1);
        this.addSlot(new Slot(this, (Container)inputInventory, 0, 14, 16){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof DyeItem || stack.getItem() == ModuleItems.RAW_MATERIAL.get() || stack.getItem() == Items.WHEAT_SEEDS || stack.getItem() == Items.BEETROOT_SEEDS || stack.getItem() == Items.MELON_SEEDS || stack.getItem() == Items.PUMPKIN_SEEDS || stack.getItem() == Items.POTATO || stack.getItem() == Items.CARROT || stack.getItem() == Items.COCOA_BEANS || stack.getItem() == Items.KELP || stack.getItem() == Items.SWEET_BERRIES || stack.getItem() == Items.GLOW_BERRIES;
            }

            public void set(ItemStack stack) {
                super.set(stack);
            }
        });
        SimpleContainer resultInventory = this.decobenchTE != null ? this.decobenchTE.getResult() : new SimpleContainer(1);
        this.addSlot(new Slot((Container)resultInventory, 0, 175, 116){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (DecobenchScreenHandler.this.decobenchTE != null) {
                    DecobenchScreenHandler.this.decobenchTE.setChanged();
                }
            }
        });
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.addSlot(new Slot(this, (Container)CONTAINER, i * 7 + j, 54 + j * 18, 37 + i * 18){

                    public boolean mayPickup(Player player) {
                        return false;
                    }
                });
            }
        }
        this.getTabItems("all");
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getColorRed() : 0;
            }

            public void set(int value) {
                DecobenchScreenHandler.this.colors[0] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getColorGreen() : 0;
            }

            public void set(int value) {
                DecobenchScreenHandler.this.colors[1] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getColorBlue() : 0;
            }

            public void set(int value) {
                DecobenchScreenHandler.this.colors[2] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getRawMaterial() : 0;
            }

            public void set(int value) {
                DecobenchScreenHandler.this.rawMaterial[0] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getCraft() : 0;
            }

            public void set(int value) {
                DecobenchScreenHandler.this.crafting[0] = value;
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return DecobenchScreenHandler.this.decobenchTE != null ? DecobenchScreenHandler.this.decobenchTE.getCraftingTimer() : 0;
            }

            public void set(int value) {
                DecobenchScreenHandler.this.crafting[1] = value;
            }
        });
        this.getTEData();
    }

    public int getColorRed() {
        this.syncDataFromTE();
        return this.colors[0];
    }

    public int getColorGreen() {
        this.syncDataFromTE();
        return this.colors[1];
    }

    public int getColorBlue() {
        this.syncDataFromTE();
        return this.colors[2];
    }

    public int getRawMaterial() {
        this.syncDataFromTE();
        return this.rawMaterial[0];
    }

    public int getCrafting() {
        this.syncDataFromTE();
        return this.crafting[0];
    }

    public int getCraftingTimer() {
        this.syncDataFromTE();
        return this.crafting[1];
    }

    private void syncDataFromTE() {
        if (this.decobenchTE != null) {
            this.colors[0] = this.decobenchTE.getColorRed();
            this.colors[1] = this.decobenchTE.getColorGreen();
            this.colors[2] = this.decobenchTE.getColorBlue();
            this.rawMaterial[0] = this.decobenchTE.getRawMaterial();
            this.crafting[0] = this.decobenchTE.getCraft();
            this.crafting[1] = this.decobenchTE.getCraftingTimer();
        }
    }

    public void scrollTo(float pos) {
        int rowMax = (this.items.size() + 7 - 1) / 7 - 4;
        int posScrolled = (int)((double)(pos * (float)rowMax) + 0.5);
        if (posScrolled < 0) {
            posScrolled = 0;
        }
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 7; ++column) {
                int item = column + (row + posScrolled) * 7;
                if (item >= 0 && item < this.items.size()) {
                    CONTAINER.setItem(column + row * 7, (ItemStack)this.items.get(item));
                    continue;
                }
                CONTAINER.setItem(column + row * 7, ItemStack.EMPTY);
            }
        }
        this.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.context.evaluate((world, pos) -> player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    public void getTabItems(String tabText) {
        this.items.clear();
        if (!ModuleBlocks.BLOCKS_PER_GROUP.containsKey(tabText)) {
            tabText = "all";
        }
        if ("all".equals(tabText)) {
            for (List<Block> tab : ModuleBlocks.BLOCKS_PER_GROUP.values()) {
                this.fillItemList(tab, this.items);
            }
        } else {
            this.fillItemList(ModuleBlocks.BLOCKS_PER_GROUP.get(tabText), this.items);
        }
        this.scrollTo(0.0f);
    }

    private void fillItemList(List<Block> tab, NonNullList<ItemStack> pItems) {
        if (tab != null) {
            tab.forEach(block -> pItems.add((Object)new ItemStack((ItemLike)block)));
        }
    }

    public void search(String searchText) {
        this.items.clear();
        String search = searchText.toLowerCase();
        for (List<Block> tab : ModuleBlocks.BLOCKS_PER_GROUP.values()) {
            this.fillItemList(tab, this.items);
        }
        this.items.removeIf(stack -> !stack.getDescriptionId().toLowerCase().contains(search));
        this.scrollTo(0.0f);
    }

    public void craft(int craft) {
        if (this.decobenchTE != null) {
            this.decobenchTE.setCraft(craft);
            this.decobenchTE.setChanged();
        } else {
            this.context.execute((world, pos) -> {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof DecobenchTileEntity) {
                    this.decobenchTE = (DecobenchTileEntity)blockEntity;
                    this.decobenchTE.setCraft(craft);
                    this.decobenchTE.setChanged();
                }
            });
        }
    }

    public void scroll(float scrollOffset) {
        this.scrollTo(scrollOffset);
    }

    public void selectTab(String tabName, float scrollOffset) {
        this.getTabItems(tabName);
        this.scrollTo(scrollOffset);
    }

    public boolean canScroll() {
        return this.items.size() > 28;
    }

    public ContainerLevelAccess getContext() {
        return this.context;
    }

    public int getItemsSize() {
        return this.items.size();
    }

    private void getTEData() {
        if (this.world != null && !this.world.isClientSide() && this.decobenchTE != null) {
            this.colors[0] = this.decobenchTE.getColorRed();
            this.colors[1] = this.decobenchTE.getColorGreen();
            this.colors[2] = this.decobenchTE.getColorBlue();
            this.rawMaterial[0] = this.decobenchTE.getRawMaterial();
            this.crafting[0] = this.decobenchTE.getCraft();
            this.crafting[1] = this.decobenchTE.getCraftingTimer();
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.getTEData();
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.decobenchTE != null) {
            this.decobenchTE.setChanged();
        }
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (slotId < 0 || slotId >= this.slots.size()) {
            if (!player.containerMenu.getCarried().isEmpty()) {
                ItemStack carried = player.containerMenu.getCarried();
                if (!player.getInventory().add(carried)) {
                    return;
                }
                player.containerMenu.setCarried(ItemStack.EMPTY);
            }
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }
}

