/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.models.bbmodel;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razznature.decocraft.common.ModuleBlocks;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBUnbakedModel;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class BBModelGeometryLoader
implements IGeometryLoader<BBGeometry> {
    public static final BBModelGeometryLoader INSTANCE = new BBModelGeometryLoader();

    public BBGeometry read(JsonObject jsonObject, JsonDeserializationContext context) {
        String decoref = null;
        if (jsonObject.has("decoref")) {
            decoref = jsonObject.get("decoref").getAsString();
        }
        String material = null;
        if (jsonObject.has("material")) {
            String fullMaterial = jsonObject.get("material").getAsString();
            material = fullMaterial.contains("/") ? fullMaterial.substring(fullMaterial.lastIndexOf(47) + 1) : (fullMaterial.contains(":") ? fullMaterial.substring(fullMaterial.indexOf(58) + 1) : fullMaterial);
            if (decoref == null) {
                decoref = material;
            }
        }
        BBModel bbModel = null;
        if (decoref != null) {
            String finalMaterial = material;
            bbModel = ModuleBlocks.MAT_TO_BB_MODEL.get(decoref);
        }
        return new BBGeometry(decoref != null ? decoref : material, bbModel);
    }

    public static class BBGeometry
    implements IUnbakedGeometry<BBGeometry> {
        private final String materialName;
        private final BBModel bbModel;

        public BBGeometry(String materialName, BBModel bbModel) {
            this.materialName = materialName;
            this.bbModel = bbModel;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            if (context.hasMaterial("particle")) {
                Material particleMaterial = context.getMaterial("particle");
                spriteGetter.apply(particleMaterial);
            }
            if (context.hasMaterial("texture0")) {
                Material texture0Material = context.getMaterial("texture0");
                spriteGetter.apply(texture0Material);
            }
            if (this.bbModel == null) {
                return null;
            }
            BBUnbakedModel unbakedModel = new BBUnbakedModel(this.materialName, this.bbModel);
            return unbakedModel.bake(baker, spriteGetter, modelState);
        }
    }
}

