/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.models.bbmodel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBModelParts;
import com.razznature.decocraft.models.libgdx.Vector3;
import com.razznature.decocraft.utils.ExpressionBuilder;
import java.awt.image.BufferedImage;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;

public class BBModelLoader {
    private static final Gson gson;

    public static void main(String[] args) {
        BBModel bbmodel = new BBModelLoader().loadModel("src/main/resources/assets/decocraft_nature/models/tmp/portable_record_player.bbmodel");
    }

    public BBModel loadModel(String path) {
        block8: {
            BBModel bBModel;
            FileReader reader = new FileReader(path);
            try {
                bBModel = this.loadModel(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ((Reader)reader).close();
            return bBModel;
        }
        return null;
    }

    public BBModel loadModel(InputStream path) {
        BBModel bBModel;
        InputStreamReader reader = new InputStreamReader(path);
        try {
            bBModel = this.loadModel(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((Reader)reader).close();
        return bBModel;
    }

    public BBModel loadModel(Reader reader) {
        BBModel bbmodel = (BBModel)gson.fromJson(reader, BBModel.class);
        this.parse(bbmodel);
        return bbmodel;
    }

    public BBModel loadModel(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        BBModel bbmodel = (BBModel)gson.fromJson((JsonElement)modelContents, BBModel.class);
        this.parse(bbmodel);
        return bbmodel;
    }

    private void parseOutlinerCube(@Nonnull BBModel bbmodel, @Nonnull BBModelParts.OutlinerCube cube, BBModelParts.OutlinerGroup parent) {
        bbmodel.outlinerFlatList.add(bbmodel.uuidMap.get(cube.uuid));
        if (null != parent) {
            bbmodel.uuidMap.get((Object)cube.uuid).parent = parent;
        }
    }

    private void parseOutlinerGroup(@Nonnull BBModel bbmodel, @Nonnull BBModelParts.OutlinerGroup root, BBModelParts.OutlinerGroup parent) {
        bbmodel.uuidMap.put(root.uuid, root);
        bbmodel.outlinerFlatList.add(root);
        if (null != parent) {
            root.parent = parent;
        }
        for (BBModelParts.OutlinerNode child : root.children) {
            this.parseOutliner(bbmodel, child, root);
        }
    }

    private void parseOutliner(@Nonnull BBModel bbmodel, @Nonnull BBModelParts.OutlinerNode node, BBModelParts.OutlinerGroup parent) {
        if (node instanceof BBModelParts.OutlinerGroup) {
            this.parseOutlinerGroup(bbmodel, (BBModelParts.OutlinerGroup)node, parent);
        } else {
            this.parseOutlinerCube(bbmodel, (BBModelParts.OutlinerCube)node, parent);
        }
    }

    private void parse(@Nonnull BBModel bbmodel) {
        bbmodel.textureImages = new ArrayList<BufferedImage>(bbmodel.textures.size());
        bbmodel.uuidMap = new HashMap<UUID, BBModelParts.ElementBase>(bbmodel.elements.size());
        for (BBModelParts.Element element : bbmodel.elements) {
            bbmodel.uuidMap.put(element.uuid, element);
        }
        bbmodel.outlinerFlatList = new ArrayList<BBModelParts.ElementBase>(bbmodel.elements.size());
        for (BBModelParts.OutlinerNode outlinerNode : bbmodel.outliner) {
            this.parseOutliner(bbmodel, outlinerNode, null);
        }
        if (bbmodel.animations != null) {
            bbmodel.animationPerName = new HashMap<String, BBModelParts.Animation>(bbmodel.animations.size());
            for (BBModelParts.Animation animation : bbmodel.animations) {
                bbmodel.animationPerName.put(animation.name, animation);
            }
        }
    }

    private static float parseFloatValue(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            try {
                return (float)new ExpressionBuilder(value).build().evaluate();
            }
            catch (Exception ex) {
                System.err.println("Failed to parse value: " + value + " - " + ex.getMessage());
                return 0.0f;
            }
        }
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(Direction.class, (Object)new DirectionAdapter());
        gsonBuilder.registerTypeAdapter(Vector3.class, (Object)new Vector3Adapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.UVCoordinate.class, (Object)new UVCoordinateAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.MarkerColor.class, (Object)new MarkerColorAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.OutlinerNode.class, (Object)new OutlinerNodeAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.UVOffset.class, (Object)new UVOffsetAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.VisibleBounds.class, (Object)new VisibleBoundsAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.Channel.class, (Object)new EnumChannelAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.Interpolation.class, (Object)new EnumInterpolationAdapter());
        gsonBuilder.registerTypeAdapter(BBModelParts.DataPoint.class, (Object)new DataPointAdapter());
        gsonBuilder.registerTypeAdapter(new TypeToken<Map<UUID, BBModelParts.Animator>>(){}.getType(), (Object)new AnimatorMapAdapter());
        gson = gsonBuilder.create();
    }

    public static class DirectionAdapter
    extends TypeAdapter<Direction> {
        public void write(JsonWriter out, Direction value) throws IOException {
            out.value(value.name().toLowerCase());
        }

        public Direction read(JsonReader in) throws IOException {
            return Direction.valueOf((String)in.nextString().toUpperCase());
        }
    }

    public static class Vector3Adapter
    extends TypeAdapter<Vector3> {
        public void write(JsonWriter out, Vector3 value) throws IOException {
            out.beginArray();
            out.value(value.x);
            out.value(value.y);
            out.value(value.z);
            out.endArray();
        }

        public Vector3 read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            float x = (float)in.nextDouble();
            float y = (float)in.nextDouble();
            float z = (float)in.nextDouble();
            in.endArray();
            return new Vector3(x, y, z);
        }
    }

    public static class UVCoordinateAdapter
    extends TypeAdapter<BBModelParts.UVCoordinate> {
        public void write(JsonWriter out, BBModelParts.UVCoordinate value) throws IOException {
            out.beginArray();
            out.value(value.u0);
            out.value(value.v0);
            out.value(value.u1);
            out.value(value.v1);
            out.endArray();
        }

        public BBModelParts.UVCoordinate read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            BBModelParts.UVCoordinate readUVCoord = new BBModelParts.UVCoordinate();
            readUVCoord.u0 = (float)in.nextDouble();
            readUVCoord.v0 = (float)in.nextDouble();
            readUVCoord.u1 = (float)in.nextDouble();
            readUVCoord.v1 = (float)in.nextDouble();
            in.endArray();
            return readUVCoord;
        }
    }

    public static class MarkerColorAdapter
    extends TypeAdapter<BBModelParts.MarkerColor> {
        public void write(JsonWriter out, BBModelParts.MarkerColor value) throws IOException {
            out.value((long)value.ordinal());
        }

        public BBModelParts.MarkerColor read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return BBModelParts.MarkerColor.LightBlue;
            }
            return BBModelParts.MarkerColor.values()[in.nextInt()];
        }
    }

    public static class OutlinerNodeAdapter
    extends TypeAdapter<BBModelParts.OutlinerNode> {
        public void write(JsonWriter out, BBModelParts.OutlinerNode value) throws IOException {
        }

        public BBModelParts.OutlinerNode read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                return (BBModelParts.OutlinerNode)gson.fromJson(in, BBModelParts.OutlinerGroup.class);
            }
            BBModelParts.OutlinerCube cube = new BBModelParts.OutlinerCube();
            cube.uuid = UUID.fromString(in.nextString());
            return cube;
        }
    }

    public static class UVOffsetAdapter
    extends TypeAdapter<BBModelParts.UVOffset> {
        public void write(JsonWriter out, BBModelParts.UVOffset value) throws IOException {
            out.beginArray();
            out.value((long)value.u_offset);
            out.value((long)value.v_offset);
            out.endArray();
        }

        public BBModelParts.UVOffset read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            BBModelParts.UVOffset readUVOffset = new BBModelParts.UVOffset();
            readUVOffset.u_offset = (int)in.nextDouble();
            readUVOffset.v_offset = (int)in.nextDouble();
            in.endArray();
            return readUVOffset;
        }
    }

    public static class VisibleBoundsAdapter
    extends TypeAdapter<BBModelParts.VisibleBounds> {
        public void write(JsonWriter out, BBModelParts.VisibleBounds value) throws IOException {
            out.beginArray();
            out.value(value.x);
            out.value(value.y);
            out.value(value.z);
            out.endArray();
        }

        public BBModelParts.VisibleBounds read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginArray();
            BBModelParts.VisibleBounds readVisibleBounds = new BBModelParts.VisibleBounds();
            readVisibleBounds.x = (float)in.nextDouble();
            readVisibleBounds.y = (float)in.nextDouble();
            readVisibleBounds.z = (float)in.nextDouble();
            in.endArray();
            return readVisibleBounds;
        }
    }

    public static class EnumChannelAdapter
    extends TypeAdapter<BBModelParts.Channel> {
        public void write(JsonWriter out, BBModelParts.Channel value) throws IOException {
            out.value(value.name().toLowerCase());
        }

        public BBModelParts.Channel read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return BBModelParts.Channel.valueOf(in.nextString().toUpperCase(Locale.ROOT));
        }
    }

    public static class EnumInterpolationAdapter
    extends TypeAdapter<BBModelParts.Interpolation> {
        public void write(JsonWriter out, BBModelParts.Interpolation value) throws IOException {
            out.value(value.name().toLowerCase());
        }

        public BBModelParts.Interpolation read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return BBModelParts.Interpolation.valueOf(in.nextString().toUpperCase(Locale.ROOT));
        }
    }

    public static class DataPointAdapter
    extends TypeAdapter<BBModelParts.DataPoint> {
        public void write(JsonWriter out, BBModelParts.DataPoint value) throws IOException {
            out.beginObject();
            out.name("x");
            out.value(value.x);
            out.name("y");
            out.value(value.y);
            out.name("z");
            out.value(value.z);
            out.endObject();
        }

        public BBModelParts.DataPoint read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            BBModelParts.DataPoint dataPoint = new BBModelParts.DataPoint();
            in.beginObject();
            String fieldname = null;
            while (in.hasNext()) {
                if (in.peek().equals((Object)JsonToken.NAME)) {
                    fieldname = in.nextName();
                }
                if ("x".equals(fieldname)) {
                    dataPoint.x = BBModelLoader.parseFloatValue(in.nextString());
                }
                if ("y".equals(fieldname)) {
                    dataPoint.y = BBModelLoader.parseFloatValue(in.nextString());
                }
                if (!"z".equals(fieldname)) continue;
                dataPoint.z = BBModelLoader.parseFloatValue(in.nextString());
            }
            in.endObject();
            return dataPoint;
        }
    }

    public static class AnimatorMapAdapter
    extends TypeAdapter<Map<UUID, BBModelParts.Animator>> {
        public void write(JsonWriter out, Map<UUID, BBModelParts.Animator> value) throws IOException {
            throw new UnsupportedOperationException("Writing not supported");
        }

        public Map<UUID, BBModelParts.Animator> read(JsonReader in) throws IOException {
            HashMap<UUID, BBModelParts.Animator> animators = new HashMap<UUID, BBModelParts.Animator>();
            Gson gson = new Gson();
            in.beginObject();
            while (in.hasNext()) {
                String key = in.nextName();
                try {
                    UUID uuid = UUID.fromString(key);
                    BBModelParts.Animator animator = (BBModelParts.Animator)gson.fromJson(in, BBModelParts.Animator.class);
                    animators.put(uuid, animator);
                }
                catch (IllegalArgumentException e) {
                    in.skipValue();
                }
            }
            in.endObject();
            return animators;
        }
    }
}

