/*
 * Decompiled with CFR 0.152.
 */
package org.primal;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;
import org.primal.Primal_Main;
import org.primal.client.renderer.block_entity.NestBlockEntityRenderer;
import org.primal.client.renderer.entity.BearRenderer;
import org.primal.client.renderer.entity.CrocodileRenderer;
import org.primal.client.renderer.entity.EagleRenderer;
import org.primal.client.renderer.entity.SharkRenderer;
import org.primal.client.renderer.replaced.FoxRenderer;
import org.primal.client.renderer.replaced.PolarBearRenderer;
import org.primal.registry.Primal_BlockEntities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;
import org.primal.util.MiscUtil;

@EventBusSubscriber(modid="primal", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@Mod(value="primal", dist={Dist.CLIENT})
public class Primal_Client {
    @SubscribeEvent
    public static void registerClientEvent(FMLClientSetupEvent event) {
        Primal_Client.registerBlockRenderers();
        if (((Boolean)Primal_Main.COMMON_CONFIG.polarBearModelChange.get()).booleanValue()) {
            EntityRenderers.register((EntityType)EntityType.POLAR_BEAR, PolarBearRenderer::new);
        }
        if (((Boolean)Primal_Main.COMMON_CONFIG.foxModelChange.get()).booleanValue()) {
            EntityRenderers.register((EntityType)EntityType.FOX, FoxRenderer::new);
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)Primal_Entities.BEAR.get(), BearRenderer::new);
        event.registerEntityRenderer((EntityType)Primal_Entities.SHARK.get(), SharkRenderer::new);
        event.registerEntityRenderer((EntityType)Primal_Entities.CROCODILE.get(), CrocodileRenderer::new);
        event.registerEntityRenderer((EntityType)Primal_Entities.EAGLE.get(), EagleRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)Primal_BlockEntities.NEST_BLOCK_ENTITY.get(), NestBlockEntityRenderer::new);
    }

    public static void registerBlockRenderers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Primal_Blocks.NEST_BLOCK.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Primal_Blocks.SHARK_TOOTH.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Primal_Blocks.RIVER_REEDS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Primal_Blocks.SHORT_RIVER_REEDS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Primal_Blocks.SEASHELLS.get()), (RenderType)RenderType.cutout());
    }

    @SubscribeEvent
    public static void registerColorBlocks(RegisterColorHandlersEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return GrassColor.getDefaultColor();
            }
            return BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos);
        }, new Block[]{(Block)Primal_Blocks.SHORT_RIVER_REEDS.get(), (Block)Primal_Blocks.RIVER_REEDS.get()});
    }

    @SubscribeEvent
    public static void registerColorItems(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> 9551193, new ItemLike[]{(ItemLike)Primal_Items.SHORT_RIVER_REEDS.get()});
        event.register((stack, tintIndex) -> tintIndex == 0 ? 9551193 : -1, new ItemLike[]{(ItemLike)Primal_Items.RIVER_REEDS.get()});
    }

    @EventBusSubscriber(modid="primal", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    private static class Primal_MainGameBusClient {
        private Primal_MainGameBusClient() {
        }

        @SubscribeEvent
        public static void customizeOverlay(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RenderGuiLayerEvent.Pre event) {
            if (VanillaGuiLayers.VEHICLE_HEALTH == event.getName()) {
                assert (Minecraft.getInstance().player != null);
                if (MiscUtil.isRidingUnfriendly((LivingEntity)Minecraft.getInstance().player)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

