/*
 * Decompiled with CFR 0.152.
 */
package org.primal.biome_modifiers.features;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import org.jetbrains.annotations.NotNull;
import org.primal.Primal_Main;
import org.primal.Primal_Registries;
import org.primal.block.SeashellsBlock;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Tags;
import org.primal.registry.Primal_WorldGen;
import org.primal.util.MiscUtil;
import org.primal.worldgen.SeashellsFeature;

public class Seashells_BiomeModifier
implements BiomeModifier {
    public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MiscUtil.createBiomeModifier(biome, builder, Primal_Tags.SPAWNS_SEASHELLS, ((List)Primal_Main.COMMON_CONFIG.seaShellsExtraBiomes.get()).stream().map(Object::toString).toList(), GenerationStep.Decoration.VEGETAL_DECORATION, (Boolean)Primal_Main.COMMON_CONFIG.seaShellsSpawnInWorld.get(), Feature.FLOWER, Seashells_BiomeModifier.createSeashells((Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchTries.get(), (Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchSpreadXZ.get(), (Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchSpreadY.get()), PlacementUtils.HEIGHTMAP_TOP_SOLID, (Integer)Primal_Main.COMMON_CONFIG.seaShellsPatchRarity.get());
        }
    }

    private static RandomPatchConfiguration createSeashells(int tries, int xzSpread, int ySpread) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                builder.add((Object)((BlockState)((BlockState)((Block)Primal_Blocks.SEASHELLS.get()).defaultBlockState().setValue((Property)SeashellsBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)SeashellsBlock.FACING, (Comparable)direction)), 1);
            }
        }
        return new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.filtered((Feature)((SeashellsFeature)((Object)Primal_WorldGen.SEASHELLS.get())), (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(builder)), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE));
    }

    @NotNull
    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)MiscUtil.createBiomeModifierSerializer("seashells_patch_spawn").get();
    }

    public static void register() {
        Primal_Registries.BIOME_MODIFIERS.register("seashells_patch_spawn", () -> MapCodec.unit((Object)new Seashells_BiomeModifier()));
    }
}

