/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.primal.biome_modifiers.features.EagleNest_BiomeModifier;
import org.primal.biome_modifiers.features.RiverReeds_BiomeModifier;
import org.primal.biome_modifiers.features.Seashells_BiomeModifier;
import org.primal.biome_modifiers.mobs.BearGroup_BiomeModifier;
import org.primal.biome_modifiers.mobs.BearSingle_BiomeModifier;
import org.primal.biome_modifiers.mobs.CrocodileNormal_BiomeModifier;
import org.primal.biome_modifiers.mobs.CrocodileWarm_BiomeModifier;
import org.primal.biome_modifiers.mobs.SharkGroup_BiomeModifier;
import org.primal.biome_modifiers.mobs.SharkSingle_BiomeModifier;

public class Primal_BiomeModifiersGenerator {
    public static void bootstrap(BootstrapContext<BiomeModifier> bootstrap) {
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/bear_single", BearSingle_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/bear_group", BearGroup_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/shark_single", SharkSingle_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/shark_group", SharkGroup_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/crocodile", CrocodileNormal_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "spawn/crocodile_warm", CrocodileWarm_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "feature/river_reeds", RiverReeds_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "feature/seashells", Seashells_BiomeModifier::new);
        Primal_BiomeModifiersGenerator.register(bootstrap, "feature/eagle_nest", EagleNest_BiomeModifier::new);
    }

    public static void register(BootstrapContext<BiomeModifier> bootstrap, String name, Supplier<? extends BiomeModifier> sup) {
        bootstrap.register(Primal_BiomeModifiersGenerator.modifierFor(name), (Object)sup.get());
    }

    public static void registerVegetation(BootstrapContext<BiomeModifier> bootstrap, String biomeModifier, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature) {
        Primal_BiomeModifiersGenerator.registerVegetation(bootstrap, Primal_BiomeModifiersGenerator.modifierFor(biomeModifier), spawnTag, placedFeature);
    }

    public static void registerVegetation(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature) {
        Primal_BiomeModifiersGenerator.registerFeature(bootstrap, biomeModifierResourceKey, spawnTag, placedFeature, GenerationStep.Decoration.VEGETAL_DECORATION);
    }

    public static void registerFeature(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, ResourceKey<PlacedFeature> placedFeature, GenerationStep.Decoration step) {
        HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
        HolderGetter placedFeatures = bootstrap.lookup(Registries.PLACED_FEATURE);
        bootstrap.register(biomeModifierResourceKey, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(spawnTag), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(placedFeature)}), step));
    }

    public static void registerMobSpawn(BootstrapContext<BiomeModifier> bootstrap, String biomeModifier, TagKey<Biome> spawnTag, EntityType<?> mob, int weight, int minGroupSize, int maxGroupSize) {
        Primal_BiomeModifiersGenerator.registerMobSpawn(bootstrap, Primal_BiomeModifiersGenerator.modifierFor(biomeModifier), spawnTag, mob, weight, minGroupSize, maxGroupSize);
    }

    public static void registerMobSpawn(BootstrapContext<BiomeModifier> bootstrap, ResourceKey<BiomeModifier> biomeModifierResourceKey, TagKey<Biome> spawnTag, EntityType<?> mob, int weight, int minGroupSize, int maxGroupSize) {
        HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
        bootstrap.register(biomeModifierResourceKey, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomes.getOrThrow(spawnTag), List.of(new MobSpawnSettings.SpawnerData(mob, weight, minGroupSize, maxGroupSize))));
    }

    public static ResourceKey<BiomeModifier> modifierFor(String id) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primal", (String)id));
    }
}

