/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.crocodile;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.CrocodileEntity;

public class CrocodileGoesToCompass
extends Behavior<CrocodileEntity> {
    public CrocodileGoesToCompass() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ADMIRING_ITEM, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, CrocodileEntity crocodile) {
        return crocodile.getCompassPos().isPresent() && crocodile.getCompassPos().get().pos().distManhattan((Vec3i)crocodile.getOnPos()) > 5;
    }

    protected void start(@NotNull ServerLevel level, CrocodileEntity crocodile, long gameTime) {
        Optional<GlobalPos> pos = crocodile.getCompassPos();
        if (pos.isEmpty()) {
            this.stop(level, crocodile, gameTime);
            return;
        }
        crocodile.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        crocodile.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos.get().pos(), 1.0f, 3));
    }

    protected void stop(@NotNull ServerLevel level, CrocodileEntity crocodile, long gameTime) {
        crocodile.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, (long)level.getRandom().nextIntBetweenInclusive(0, 100) + 200L);
    }
}

