/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.eagle;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_MemoryModuleTypes;

public class EagleSearchHome
extends Behavior<EagleEntity> {
    public EagleSearchHome() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EagleEntity eagle) {
        return eagle.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()) && level.getBlockState((BlockPos)eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).get()).is((Block)Primal_Blocks.NEST_BLOCK.get());
    }

    protected void start(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        if (!this.checkExtraStartConditions(level, eagle) || eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).isEmpty()) {
            this.stop(level, (LivingEntity)eagle, gameTime);
            return;
        }
        GlobalPos pos = new GlobalPos(level.dimension(), (BlockPos)eagle.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).get());
        eagle.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        eagle.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(pos.pos(), 1.0f, 3));
        eagle.getBrain().setMemory(MemoryModuleType.HOME, (Object)pos);
        level.broadcastEntityEvent((Entity)eagle, (byte)14);
    }
}

