/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;

public class BirdReturnHome
extends Behavior<LivingEntity> {
    private final int startDistance;
    private final int stopDistance;
    private final boolean hasOffset;

    public BirdReturnHome(int startDistance, int stopDistance, boolean hasOffset) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.HOME, (Object)MemoryStatus.VALUE_PRESENT));
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.hasOffset = hasOffset;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull LivingEntity eagle) {
        if (eagle.getBrain().getMemory(MemoryModuleType.HOME).isEmpty()) {
            return false;
        }
        GlobalPos pos = (GlobalPos)eagle.getBrain().getMemory(MemoryModuleType.HOME).get();
        return eagle.getOnPos().distSqr((Vec3i)pos.pos()) >= (double)this.startDistance;
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull LivingEntity eagle, long gameTime) {
        if (eagle.getBrain().getMemory(MemoryModuleType.HOME).isEmpty()) {
            return false;
        }
        GlobalPos pos = (GlobalPos)eagle.getBrain().getMemory(MemoryModuleType.HOME).get();
        return eagle.getOnPos().distSqr((Vec3i)pos.pos()) > (double)this.stopDistance;
    }

    protected void start(@NotNull ServerLevel level, @NotNull LivingEntity eagle, long gameTime) {
        if (eagle.getBrain().getMemory(MemoryModuleType.HOME).isEmpty()) {
            this.stop(level, eagle, gameTime);
            return;
        }
        GlobalPos pos = (GlobalPos)eagle.getBrain().getMemory(MemoryModuleType.HOME).get();
        BlockPos finalPos = pos.pos();
        if (this.hasOffset) {
            finalPos = pos.pos().offset(eagle.getRandom().nextInt(0, 5), eagle.getRandom().nextInt(0, 5), eagle.getRandom().nextInt(0, 5));
        }
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)eagle, (BlockPos)finalPos, (float)1.0f, (int)0);
    }
}

