/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.shark;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.SharkEntity;

public class SharkJumpOutWater
extends Behavior<SharkEntity> {
    private boolean breached;

    public SharkJumpOutWater() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT), 60);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull SharkEntity shark) {
        Optional target = shark.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        Direction direction = shark.getMotionDirection();
        int i = direction.getStepX();
        int j = direction.getStepZ();
        BlockPos blockpos = shark.blockPosition();
        return target.isPresent() && !((LivingEntity)target.get()).isInWater() && shark.isInWater();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull SharkEntity entity, long gameTime) {
        return true;
    }

    protected void start(@NotNull ServerLevel level, @NotNull SharkEntity shark, long gameTime) {
        Optional target = shark.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (target.isEmpty()) {
            return;
        }
        shark.getNavigation().stop();
        BehaviorUtils.lookAtEntity((LivingEntity)shark, (LivingEntity)((LivingEntity)target.get()));
    }

    protected void tick(@NotNull ServerLevel level, @NotNull SharkEntity shark, long gameTime) {
    }

    protected void stop(@NotNull ServerLevel level, @NotNull SharkEntity shark, long gameTime) {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = shark.level().getFluidState(shark.blockPosition());
            this.breached = fluidstate.is(FluidTags.WATER);
        }
        Direction direction = shark.getMotionDirection();
        shark.setDeltaMovement(shark.getDeltaMovement().add((double)direction.getStepX() * 0.3, 0.4, (double)direction.getStepZ() * 0.3));
        Vec3 vec3 = shark.getDeltaMovement();
        if (vec3.y * vec3.y < (double)0.03f && shark.getXRot() != 0.0f) {
            shark.setXRot(Mth.rotLerp((float)0.2f, (float)shark.getXRot(), (float)0.0f));
        } else if (vec3.length() > (double)1.0E-5f) {
            double d0 = vec3.horizontalDistance();
            double d1 = Math.atan2(-vec3.y, d0) * 180.0 / 3.1415927410125732;
            shark.setXRot((float)d1);
        }
    }

    private boolean waterIsClear(@NotNull SharkEntity shark, BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.offset(dx * scale, 0, dz * scale);
        return shark.level().getFluidState(blockpos).is(FluidTags.WATER) && !shark.level().getBlockState(blockpos).blocksMotion();
    }

    private boolean surfaceIsClear(@NotNull SharkEntity shark, BlockPos pos, int dx, int dz, int scale) {
        return shark.level().getBlockState(pos.offset(dx * scale, 1, dz * scale)).isAir() && shark.level().getBlockState(pos.offset(dx * scale, 2, dz * scale)).isAir();
    }
}

